<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>403 – صلاحية مرفوضة</title>

<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
body {
    margin: 0; padding: 0; height: 100vh;
    background: #0f172a;
    font-family: 'Tajawal', sans-serif;
    overflow: hidden;
    display: flex; justify-content: center; align-items: center;
}

/* Animation circles */
.circle {
    position: absolute;
    border-radius: 50%;
    background: rgba(255,255,255,0.05);
    animation: float 8s infinite ease-in-out;
}
.circle:nth-child(1){ width:200px;height:200px; top:10%; left:10%; animation-duration:9s; }
.circle:nth-child(2){ width:300px;height:300px; bottom:15%; right:15%; animation-duration:12s; }
.circle:nth-child(3){ width:150px;height:150px; top:50%; right:30%; animation-duration:7s; }

@keyframes float {
    0%{transform:translateY(0);}
    50%{transform:translateY(-25px);}
    100%{transform:translateY(0);}
}

/* Glass card */
.error-box {
    background: rgba(255,255,255,0.08);
    border-radius: 20px;
    width: 90%; max-width: 450px;
    text-align: center;
    padding: 40px;
    border: 1px solid rgba(255,255,255,0.2);
    backdrop-filter: blur(12px);
    animation: fadeIn 1s ease;
}
@keyframes fadeIn {
    from {opacity:0; transform:scale(0.9);}
    to   {opacity:1; transform:scale(1);}
}

/* Logo — transparent, no padding */
.error-box img {
    width: 95px;
    height: auto;
    margin-bottom: 15px;
    animation: bounce 2s infinite;
    background: transparent !important;
}
@keyframes bounce {
    0%,100%{transform:translateY(0);}
    50%{transform:translateY(-8px);}
}

.error-code {
    font-size: 50px; font-weight: 700; color: #fbbf24;
}

.error-text {
    color: #e2e8f0; font-size: 18px; margin-bottom: 25px;
}

/* Button */
.error-box a {
    display:inline-block;
    background:#6366f1;
    color:white;
    padding:12px 25px;
    border-radius:10px;
    text-decoration:none;
    font-weight:bold;
    transition:0.3s;
}
.error-box a:hover { background:#4f46e5; }
</style>
</head>

<body>

<div class="circle"></div>
<div class="circle"></div>
<div class="circle"></div>

<div class="error-box">

    <img src="assets/img/logo.png" alt="Logo">

    <div class="error-code">403</div>
    <div class="error-text">ليس لديك صلاحية الوصول لهذه الصفحة.</div>

    <a href="index.php"><i class="bi bi-arrow-right-circle"></i> العودة</a>

</div>

</body>
</html>