<?php
session_start();
require_once "../../config/db.php";
require_once "functions_backup.php";

$auto = get_setting("auto_backup","off");
if ($auto !== "on") exit;

$telegram_token = get_setting("telegram_token", "");
$telegram_chat  = get_setting("telegram_chat_id", "");
$server_url     = get_setting("server_url", "");

$error = "";
$filename = "";

$path = create_full_backup($filename, $error);

if (!$path) {
    sendTelegram($telegram_token, $telegram_chat,
    "❌ <b>فشل النسخ التلقائي</b>\nخطأ: $error");
    exit;
}

sendTelegram($telegram_token, $telegram_chat,
"🤖 <b>نسخة تلقائية جديدة</b>\n
📁 <code>$filename</code>\n
📦 الحجم: " . round(filesize($path)/1024/1024,2) . " MB\n
🕒 " . date("Y-m-d H:i"));

if ($server_url) {
    upload_to_external($path, $filename, $server_url);
    sendTelegram($telegram_token, $telegram_chat, "🌍 تم رفع النسخة تلقائياً للسيرفر الخارجي");
}

echo "OK";