<?php
// =========================================================
// 📌 ملف دوال النسخ الاحتياطي — FINAL for macOS + XAMPP
// =========================================================

// =========================================================
// جلب إعداد من قاعدة البيانات
// =========================================================
function get_setting($k, $default = "")
{
    global $conn;
    $q = $conn->prepare("SELECT key_value FROM backup_settings WHERE key_name=? LIMIT 1");
    $q->execute([$k]);
    return $q->fetchColumn() ?: $default;
}

// =========================================================
// 📌 إرسال رسالة منظمة إلى Telegram
// =========================================================
function sendTelegram($token, $chatId, $text)
{
    if (!$token || !$chatId) return false;

    $url = "https://api.telegram.org/bot$token/sendMessage";

    $post = [
        "chat_id"    => $chatId,
        "text"       => $text,
        "parse_mode" => "HTML"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);

    return $res;
}

// =========================================================
// 📌 رفع النسخة الاحتياطية إلى السيرفر الخارجي
// =========================================================
function upload_to_external($file_path, $file_name, $server_url)
{
    if (!$server_url) return false;

    $ch = curl_init($server_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, [
        "file"     => new CURLFile($file_path),
        "filename" => $file_name
    ]);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);

    return $res;
}

// =========================================================
// 📌 إنشاء نسخة ZIP كاملة + SQL كامل (Mac + XAMPP)
// =========================================================
function create_full_backup(&$filename_out, &$error_out)
{
    global $conn;

    // قراءة بيانات DB من config/db.php
    $host   = $GLOBALS['host']   ?? "localhost";
    $user   = $GLOBALS['user']   ?? "root";
    $pass   = $GLOBALS['pass']   ?? "";
    $dbname = $GLOBALS['dbname'] ?? "nebres_university";

    // مجلد النسخ
    $backup_dir = __DIR__ . "/files/";
    if (!is_dir($backup_dir)) mkdir($backup_dir, 0777, true);

    // اسم النسخة
    $filename = "backup_" . date("Y-m-d_H-i-s") . ".zip";
    $zip_path = $backup_dir . $filename;

    // =========================================================
    // 1) إنشاء SQL (Mac + XAMPP)
    // =========================================================

    $mysqldump_path = "/Applications/XAMPP/xamppfiles/bin/mysqldump";

    if (!file_exists($mysqldump_path)) {
        $error_out = "❌ mysqldump غير موجود في المسار المتوقع.";
        return false;
    }

    $sql_tmp = $backup_dir . "db_temp.sql";

    $cmd = "$mysqldump_path -h {$host} -u {$user} -p'{$pass}' {$dbname} > {$sql_tmp}";
    system($cmd);

    if (!file_exists($sql_tmp) || filesize($sql_tmp) == 0) {
        $error_out = "❌ فشل إنشاء SQL — تحقق من صلاحيات mysqldump أو كلمة المرور";
        return false;
    }

    // =========================================================
    // 2) إنشاء ZIP
    // =========================================================
    $zip = new ZipArchive();
    if ($zip->open($zip_path, ZipArchive::CREATE) !== TRUE) {
        $error_out = "❌ فشل إنشاء ملف ZIP";
        return false;
    }

    // إضافة SQL
    $zip->addFile($sql_tmp, "database.sql");

    // =========================================================
    // 3) إضافة ملفات المشروع بالكامل
    // =========================================================
    $root = realpath(__DIR__ . "/../../");

    $it = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($root, FilesystemIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );

    foreach ($it as $file) {

        $path = $file->getRealPath();

        // منع إضافة النسخ الاحتياطية داخل النسخة
        if (strpos($path, "/admin/backups/files") !== false) continue;

        if ($file->isFile()) {
            $local = substr($path, strlen($root) + 1);
            $zip->addFile($path, $local);
        }
    }

    $zip->close();
    @unlink($sql_tmp);

    // =========================================================
    // 4) تسجيل النسخة في قاعدة البيانات
    // =========================================================
    $size = filesize($zip_path);

    $conn->prepare("
        INSERT INTO backup_logs (file_name, file_size, created_at)
        VALUES (?, ?, NOW())
    ")->execute([$filename, $size]);

    // إخراج اسم الملف
    $filename_out = $filename;
    return $zip_path;
}