<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

// حماية الدخول
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: ../login.php");
    exit;
}

// جلب معلومات بسيطة عن النسخ من جدول backup_logs (إن وجد)
$last_backup = null;
$total_backups = 0;

try {
    $stmt = $conn->query("SELECT COUNT(*) FROM backup_logs");
    $total_backups = $stmt->fetchColumn();

    $stmt2 = $conn->query("SELECT * FROM backup_logs ORDER BY id DESC LIMIT 1");
    $last_backup = $stmt2->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    // لو الجدول غير موجود نتجاهل الخطأ
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة النسخ الاحتياطية</title>

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<style>
body {
    font-family: "Tajawal", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
    background-color: #f5f7fb;
}

/* تخطيط عام */
.layout-wrapper {
    min-height: 100vh;
    display: flex;
}

/* السايدبار */
.sidebar {
    width: 250px;
    background-color: #ffffff;
    border-left: 1px solid #e5e7eb;
    border-right: 1px solid #e5e7eb;
    box-shadow: 0 0 25px rgba(15, 23, 42, 0.08);
    display: flex;
    flex-direction: column;
}

.sidebar-header {
    padding: 18px 20px;
    border-bottom: 1px solid #e5e7eb;
}

.sidebar-title {
    font-size: 17px;
    font-weight: 700;
    display: flex;
    align-items: center;
    gap: 8px;
    color: #111827;
}

.sidebar-title i {
    font-size: 20px;
    color: #2563eb;
}

.sidebar-menu {
    list-style: none;
    padding: 12px 0;
    margin: 0;
    flex: 1;
}

.sidebar-menu li {
    margin: 2px 0;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 9px 20px;
    text-decoration: none;
    color: #4b5563;
    font-size: 14px;
    border-inline-start: 3px solid transparent;
    transition: all 0.18s ease-in-out;
}

.sidebar-menu a i {
    font-size: 16px;
}

.sidebar-menu a:hover {
    background-color: #eff6ff;
    color: #1d4ed8;
}

.sidebar-menu a.active {
    background-color: #e0ecff;
    color: #1d4ed8;
    border-inline-start-color: #2563eb;
    font-weight: 600;
}

/* المحتوى الرئيسي */
.main-content {
    flex: 1;
    padding: 24px 28px;
}

.page-header {
    margin-bottom: 18px;
}

.page-header h3 {
    font-size: 22px;
    font-weight: 700;
    color: #111827;
    display: flex;
    align-items: center;
    gap: 8px;
}

.page-header h3 span.icon {
    font-size: 22px;
}

/* كرت الملخص */
.card-summary {
    border-radius: 16px;
    border: 1px solid #e5e7eb;
    box-shadow: 0 10px 30px rgba(15,23,42,0.06);
}

/* شارة صغيرة */
.badge-soft {
    background-color: #eef2ff;
    color: #4f46e5;
    font-size: 11px;
    padding: 4px 8px;
    border-radius: 999px;
}

/* زر أيقونة صغير */
.btn-icon {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
    font-size: 14px;
}

/* بطاقات معلومات */
.info-item {
    font-size: 14px;
    color: #4b5563;
}

/* responsive */
@media (max-width: 992px) {
    .layout-wrapper {
        flex-direction: column;
    }
    .sidebar {
        width: 100%;
        flex-direction: row;
        overflow-x: auto;
    }
    .sidebar-header {
        border-bottom: none;
        border-inline-end: 1px solid #e5e7eb;
    }
    .sidebar-menu {
        display: flex;
        flex-direction: row;
        padding-inline: 8px;
    }
    .sidebar-menu a {
        padding-inline: 16px;
        padding-block: 10px;
        border-inline-start: none;
        border-bottom: 2px solid transparent;
    }
    .sidebar-menu a.active {
        border-bottom-color: #2563eb;
        border-inline-start-color: transparent;
    }
}
</style>
</head>
<body>

<div class="layout-wrapper">

    <!-- سايدبار النسخ الاحتياطية -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-title">
                <i class="bi bi-hdd-stack"></i>
                <span>لوحة النسخ الاحتياطية</span>
            </div>
            <div class="text-muted small mt-1">خاصة بمشروع جامعة النبراس</div>
        </div>

        <ul class="sidebar-menu">
            <li>
                <a href="index.php" class="active">
                    <i class="bi bi-speedometer2"></i>
                    <span>نظرة عامة</span>
                </a>
            </li>
            <li>
                <a href="create.php">
                    <i class="bi bi-cloud-arrow-up"></i>
                    <span>إنشاء نسخة الآن</span>
                </a>
            </li>
            <li>
                <a href="restore.php">
                    <i class="bi bi-arrow-counterclockwise"></i>
                    <span>استرجاع آخر نسخة</span>
                </a>
            </li>
            <li>
                <a href="settings.php">
                    <i class="bi bi-gear"></i>
                    <span>إعدادات النسخ</span>
                </a>
            </li>
            <li>
                <a href="logs.php">
                    <i class="bi bi-journal-text"></i>
                    <span>سجل النسخ (backup_logs)</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- المحتوى -->
    <main class="main-content">

        <div class="page-header">
            <h3>
                <span class="icon">📦</span>
                <span>النسخ الاحتياطية – نظرة عامة</span>
            </h3>
            <div class="text-muted small mt-1">
                من هنا يمكنك تجربة النسخ اليدوي، استرجاع آخر نسخة، وضبط الربط مع السيرفر الخارجي وتيليجرام.
            </div>
        </div>

        <div class="card card-summary">
            <div class="card-body">

                <div class="d-flex justify-content-between align-items-start mb-3">
                    <div>
                        <div class="d-flex align-items-center gap-2 mb-1">
                            <span class="badge-soft">Backup Control Center</span>
                        </div>
                        <h5 class="mb-1">لوحة التحكم في النسخ الاحتياطية</h5>
                        <p class="text-muted small mb-0">
                            قم بإنشاء نسخة Zip كاملة تشمل ملفات المشروع وقاعدة البيانات، أو استرجاع آخر نسخة تم إنشاؤها.
                        </p>
                    </div>
                    <div class="text-end">
                        <div class="info-item">
                            <span class="text-muted">إجمالي النسخ:</span>
                            <strong><?= (int)$total_backups ?></strong>
                        </div>
                        <?php if ($last_backup): ?>
                            <div class="info-item">
                                <span class="text-muted">آخر نسخة:</span>
                                <strong><?= htmlspecialchars($last_backup['file_name']) ?></strong>
                            </div>
                            <div class="info-item">
                                <span class="text-muted">بتاريخ:</span>
                                <strong><?= htmlspecialchars($last_backup['created_at']) ?></strong>
                            </div>
                        <?php else: ?>
                            <div class="info-item text-warning">
                                لا توجد نسخ مسجّلة حتى الآن.
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <hr class="my-3">

                <div class="row g-3 align-items-center">
                    <div class="col-md-8">
                        <div class="d-flex flex-wrap gap-2">

                            <!-- زر تجربة النسخ الآن -->
                            <a href="create.php" class="btn btn-primary btn-icon">
                                <i class="bi bi-play-circle-fill"></i>
                                <span>🚀 تجربة النسخ الآن</span>
                            </a>

                            <!-- زر استرجاع آخر نسخة -->
                            <a href="restore.php" class="btn btn-success btn-icon">
                                <i class="bi bi-arrow-counterclockwise"></i>
                                <span>♻ استرجاع آخر نسخة</span>
                            </a>

                            <!-- زر الإعدادات -->
                            <a href="settings.php" class="btn btn-outline-secondary btn-icon">
                                <i class="bi bi-gear"></i>
                                <span>إعدادات الاتصال (السيرفر + تيليجرام)</span>
                            </a>

                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="border rounded-3 p-3 bg-light">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-info-circle text-primary me-2"></i>
                                <strong class="small">ملاحظات سريعة</strong>
                            </div>
                            <ul class="small mb-0 ps-3">
                                <li>النسخة عبارة عن ملف Zip يحتوي على كل ملفات الموقع + SQL كامل.</li>
                                <li>تأكد من إعداد السيرفر الخارجي وتيليجرام من صفحة الإعدادات.</li>
                                <li>استرجاع النسخة يفضّل أن يتم في وقت لا يوجد فيه مستخدمين على النظام.</li>
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </main>

</div>

</body>
</html>