<?php
session_start();
require_once "../../config/db.php";

if (!isset($_SESSION['admin_logged_in'])) {
    echo json_encode(["status"=>"error","msg"=>"غير مصرح"]);
    exit;
}

function save_setting($k,$v){
    global $conn;
    $stmt = $conn->prepare("
        INSERT INTO backup_settings (key_name, key_value)
        VALUES (?, ?)
        ON DUPLICATE KEY UPDATE key_value=VALUES(key_value)
    ");
    $stmt->execute([$k,$v]);
}

$fields = [
    "auto_backup",
    "schedule_type",
    "schedule_value",
    "server_url",
    "telegram_token",
    "telegram_chat_id"
];

foreach($fields as $f){
    if(isset($_POST[$f])){
        save_setting($f, $_POST[$f]);
    }
}

echo json_encode(["status"=>"success","msg"=>"✔ تم حفظ الإعدادات بنجاح"]);
exit;
?>