<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// جلب جميع القنوات
$channels = $conn->query("SELECT * FROM channels ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// عنوان الصفحة
$page_title = "قنوات التقديم";

// تضمين الهيدر + النافبار
require_once "../includes/header.php";
require_once "../includes/navbar.php";
?>

<style>
/* تصميمك الأصلي بالكامل */
body {
    background: radial-gradient(circle at top,#0f172a,#1e1b4b);
    font-family:"Tajawal";
    color:white;
}

.container-custom {
    max-width:900px;
    margin:30px auto;
}

.glass-card {
    background:rgba(11, 11, 11, 0.07);
    padding:25px;
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.2);
    box-shadow:0 10px 40px rgba(0,0,0,0.45);
}

/* ⭐ تغيير لون الخط داخل الجدول */
.table thead th {
    background:rgba(18, 14, 14, 1);
    color:#7dd3fc;  /* سماوي جميل */
    font-weight:700;
}

.table tbody td {
    color:black !important; /* نص أبيض ناعم */
    font-size:15px;
    font-weight:500;
}

/* صفوف الجدول */
.table tbody tr {
    background:rgba(0, 0, 0, 1) !important;
}

/* زر الإضافة */
.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    color:white;
  
    border-radius:10px;
    padding:10px 16px;
    font-weight:700;
}

/* ⭐ لون الحقول الجديد */
input.form-control,
select.form-control,
textarea.form-control {
    background: rgba(252, 254, 255, 1) !important;  /* سماوي جميل */
    border: 1px solid rgba(255,255,255,0.3) !important;
    color: #232121ff !important;
    border-radius: 12px;
}

input.form-control::placeholder,
textarea.form-control::placeholder {
    color: #dbeafe !important; /* placeholder سماوي فاتح */
}
</style>

<div class="page-content">

    <div class="container-custom">
    <div class="glass-card">

        <div class="d-flex justify-content-between mb-3">
            <h4 style="color:#fff;">📌 جميع القنوات</h4>
            <a href="add.php" class="btn-main">➕ إضافة قناة</a>
        </div>

        <table class="table table-bordered text-center align-middle">
            <thead>
                <tr>
                    <th>#</th>
                    <th>اسم القناة</th>
                    <th>عمليات</th>
                </tr>
            </thead>

            <tbody>
            <?php if (empty($channels)): ?>
                <tr><td colspan="3" style="color:#a5f3fc;">لا توجد قنوات</td></tr>
            <?php endif; ?>

            <?php foreach ($channels as $ch): ?>
                <tr>
                    <td><?= $ch['id'] ?></td>
                    <td style="color:#e0f2fe;"><?= htmlspecialchars($ch['channel_name']) ?></td>
                    <td>
                        <a href="edit.php?id=<?= $ch['id'] ?>" class="btn btn-warning btn-sm">تعديل</a>
                        <a href="delete.php?id=<?= $ch['id'] ?>"
                           onclick="return confirm('هل تريد حذف هذه القناة؟');"
                           class="btn btn-danger btn-sm">حذف</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>

    </div>
    </div>

</div>

<?php require_once "../includes/footer.php"; ?>