<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

// حماية تسجيل الدخول
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// التأكد من ID
if (!isset($_GET['id'])) {
    die("❌ معرف الكلية غير موجود.");
}

$id = intval($_GET['id']);

// جلب بيانات الكلية للتأكد أنها موجودة
$stmt = $conn->prepare("SELECT * FROM colleges WHERE id = ? LIMIT 1");
$stmt->execute([$id]);
$college = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$college) {
    die("❌ الكلية غير موجودة.");
}

// حذف الكلية
$delete = $conn->prepare("DELETE FROM colleges WHERE id = ?");
$delete->execute([$id]);

// إعادة التوجيه إلى القائمة مع رسالة نجاح
header("Location: list.php?deleted=1");
exit;
?>
