<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("SELECT * FROM colleges WHERE id = ? LIMIT 1");
$stmt->execute([$id]);
$college = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$college) {
    die("❌ الكلية غير موجودة.");
}

$success = "";
$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $university_name = sanitize($_POST['university_name']);
    $college_name    = sanitize($_POST['college_name']);
    $study_type      = sanitize($_POST['study_type']);
    $fee             = intval($_POST['fee']); // ⭐ تمت الإضافة

    if (empty($college_name)) {
        $error = "❌ يجب كتابة اسم الكلية.";
    } else {

        $update = $conn->prepare("
            UPDATE colleges 
            SET university_name=?, college_name=?, study_type=?, fee=?
            WHERE id=?
        ");

        $update->execute([$university_name, $college_name, $study_type, $fee, $id]);

        $success = "✔ تم تحديث بيانات الكلية بنجاح!";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل الكلية</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<style>
/* نفس التصميم بدون تغيير */
body {
    background: radial-gradient(circle at top,#0f172a,#1e1b4b);
    font-family:"Tajawal";
    color:white;
}
.navbar-custom {
    background: linear-gradient(90deg,#1e293b,#4338ca);
    padding:14px 20px; 
    display:flex; 
    align-items:center;
}
.navbar-custom img {
    width:45px;height:45px;border-radius:10px;background:white;
}
.navbar-custom .title {
    font-size:22px;font-weight:700;margin-right:15px;
}
.glass-box {
    max-width:600px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.2);
    box-shadow:0 10px 40px rgba(0,0,0,0.45);
}
.form-control, select {
    background:rgba(255,255,255,0.15);
    border:1px solid rgba(255,255,255,0.3);
    color:white;
    border-radius:12px;
}
label { font-weight:600; }
.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    padding:12px;
    border-radius:12px;
    font-weight:700;
    color:white;
    width:100%;
}
.success-box {
    background:rgba(16,185,129,0.25);
    border:1px solid rgba(16,185,129,0.4);
    padding:12px;
    border-radius:12px;
    text-align:center;
    color:#bbf7d0;
    margin-bottom:20px;
}
.error-box {
    background:rgba(239,68,68,0.25);
    border:1px solid rgba(239,68,68,0.4);
    padding:12px;
    border-radius:12px;
    text-align:center;
    color:#fecaca;
    margin-bottom:20px;
}
</style>

</head>
<body>

<div class="navbar-custom">
    <img src="../../assets/images/logo.png">
    <div class="title">تعديل بيانات الكلية</div>
</div>

<div class="glass-box">

<?php if ($success): ?>
    <div class="success-box"><?= $success ?></div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="error-box"><?= $error ?></div>
<?php endif; ?>

<form method="POST">

    <label class="mb-1">اسم الجامعة</label>
    <input type="text" name="university_name" class="form-control mb-3"
           value="<?= htmlspecialchars($college['university_name']) ?>" required>

    <label class="mb-1">اسم الكلية / القسم</label>
    <input type="text" name="college_name" class="form-control mb-3"
           value="<?= htmlspecialchars($college['college_name']) ?>" required>

    <label class="mb-1">نوع الدراسة</label>
    <select name="study_type" class="form-control mb-3" required>
        <option value="صباحي" <?= $college['study_type']=="صباحي"?"selected":"" ?>>صباحي</option>
        <option value="مسائي" <?= $college['study_type']=="مسائي"?"selected":"" ?>>مسائي</option>
    </select>

    <!-- ⭐ حقل القسط الجديد -->
    <label class="mb-1">قسط السنة (IQD)</label>
    <input type="number" name="fee" class="form-control mb-3"
           value="<?= intval($college['fee']) ?>" required>

    <button class="btn-main mt-3">💾 حفظ التعديلات</button>

</form>

</div>

</body>
</html>