<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// جلب جميع الكليات
$colleges = $conn->query("SELECT * FROM colleges ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

// عنوان الصفحة
$page_title = "الكليات والأقسام";

// تحميل الهيدر والنافبار
require_once "../includes/header.php";
require_once "../includes/navbar.php";
?>

<style>
/* نفس التصميم الأصلي 100% بدون أي تغيير */
body {
    background: radial-gradient(circle at top,#0f172a,#1e1b4b);
    font-family:"Tajawal";
    color:white;
}

.container-custom {
    max-width:900px;
    margin:30px auto;
}

.glass-card {
    background:rgba(255,255,255,0.07);
    padding:25px;
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.15);
    box-shadow:0 10px 40px rgba(0,0,0,0.45);
}

/* الجدول */
.table {
    background-color: transparent !important;
    color: #fff !important;
}
.table thead th {
    background-color: rgba(0,0,0,0.45) !important;
    color: #fff !important;
    font-weight: 700;
    border-color: rgba(255,255,255,0.25) !important;
}

.table tbody tr {
    background-color: rgba(0,0,0,0.35) !important;
}

.table td, .table th {
    background-color: rgba(0,0,0,0.20) !important;
    color: #fff !important;
    border-color: rgba(255,255,255,0.20) !important;
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    color:white;
    border:0;
    padding:10px 16px;
    border-radius:10px;
    font-weight:700;
}
</style>

<div class="page-content">

    <div class="container-custom">

        <div class="glass-card">

            <div class="d-flex justify-content-between mb-3">
                <h4>📘 جميع الكليات</h4>
                <a href="add.php" class="btn-main">➕ إضافة كلية</a>
            </div>

            <table class="table table-bordered text-center align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>اسم الكلية</th>
                        <th>نوع الدراسة</th>
                        <th>قسط السنة</th>
                        <th>عمليات</th>
                    </tr>
                </thead>

                <tbody>
                <?php if (empty($colleges)): ?>
                    <tr><td colspan="5" class="text-warning">لا توجد كليات</td></tr>
                <?php endif; ?>

                <?php foreach ($colleges as $c): ?>
                    <tr>
                        <td><?= $c['id'] ?></td>
                        <td><?= htmlspecialchars($c['college_name']) ?></td>
                        <td><?= htmlspecialchars($c['study_type']) ?></td>
                        <td><?= number_format($c['fee']) ?> د.ع</td>

                        <td>
                            <a href="edit.php?id=<?= $c['id'] ?>" class="btn btn-warning btn-sm">تعديل</a>
                            <a href="delete.php?id=<?= $c['id'] ?>"
                               onclick="return confirm('هل تريد حذف هذه الكلية؟');"
                               class="btn btn-danger btn-sm">حذف</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>

            </table>

        </div>

    </div>

</div>

<?php require_once "../includes/footer.php"; ?>