<?php
session_start();
error_reporting(E_ALL);
ini_set("display_errors",1);

require_once "../config/db.php";
require_once "../config/security.php";

// حماية الدخول
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$page_title = "لوحة مدير التسجيل";

// جلب الإحصائيات الأساسية
$total_students = $conn->query("SELECT COUNT(*) FROM students")->fetchColumn();
$pending        = $conn->query("SELECT COUNT(*) FROM students WHERE status='pending'")->fetchColumn();
$verified       = $conn->query("SELECT COUNT(*) FROM students WHERE status='verified'")->fetchColumn();
$accepted       = $conn->query("SELECT COUNT(*) FROM students WHERE status='accepted'")->fetchColumn();

$accounts_total = $conn->query("SELECT COUNT(*) FROM accounts")->fetchColumn();

// أعلى الأقسام تسجيلًا
$top_departments = $conn->query("
    SELECT college_name, study_type, COUNT(*) AS cnt
    FROM students
    GROUP BY college_name, study_type
    ORDER BY cnt DESC LIMIT 6
")->fetchAll(PDO::FETCH_ASSOC);

// آخر 10 طلاب
$recent_students = $conn->query("
    SELECT id, full_name, created_at, college_name 
    FROM students ORDER BY id DESC LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// آخر ملفات PDF
$recent_pdfs = $conn->query("
    SELECT student_id, pdf_path AS pdf_name, created_at AS uploaded_at
    FROM student_pdf ORDER BY id DESC LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// ===============================
//   يقدم الهيدر (HTML + CSS)
// ===============================
include "includes/header.php";?>

<!-- ======================== -->
<!--       SIDEBAR            -->
<!-- ======================== -->


<!-- ======================== -->
<!--       NAVBAR             -->
<!-- ======================== -->
<div class="content">
<?php include "includes/navbar.php"; ?>

<div class="container-fluid mt-3">

    <h3 class="text-white mb-4">📊 الإحصائيات العامة</h3>

    <div class="row g-3">
        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-label">إجمالي الطلاب</div>
                <div class="stat-value"><?= number_format($total_students) ?></div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-label">غير مدقق</div>
                <div class="stat-value"><?= number_format($pending) ?></div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-label">مدقق</div>
                <div class="stat-value"><?= number_format($verified) ?></div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-label">مقبول</div>
                <div class="stat-value"><?= number_format($accepted) ?></div>
            </div>
        </div>
    </div>

    <!-- أعلى الأقسام -->
    <div class="card-glass mt-4">
        <h4 class="text-white mb-3">🏛️ أعلى الأقسام تسجيلاً</h4>
        <div class="table-responsive">
            <table class="table table-bordered text-center align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>القسم</th>
                        <th>نوع الدراسة</th>
                        <th>عدد الطلاب</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!$top_departments): ?>
                        <tr><td colspan="3">لا يوجد بيانات</td></tr>
                    <?php else: ?>
                        <?php foreach ($top_departments as $d): ?>
                        <tr>
                            <td><?= htmlspecialchars($d['college_name']) ?></td>
                            <td><?= htmlspecialchars($d['study_type']) ?></td>
                            <td><?= number_format($d['cnt']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- آخر الطلاب -->
    <div class="card-glass mt-4">
        <h4 class="text-white mb-3">🧍‍♂️ آخر 10 طلاب</h4>
        <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
                <thead class="table-dark">
                    <tr>
                        <th>الاسم</th>
                        <th>القسم</th>
                        <th>تاريخ التقديم</th>
                        <th>عرض</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!$recent_students): ?>
                        <tr><td colspan="4">لا يوجد طلاب</td></tr>
                    <?php else: ?>
                        <?php foreach ($recent_students as $rs): ?>
                            <tr>
                                <td><?= htmlspecialchars($rs['full_name']) ?></td>
                                <td><?= htmlspecialchars($rs['college_name']) ?></td>
                                <td><?= $rs['created_at'] ?></td>
                                <td>
                                    <a href="student_view.php?id=<?= $rs['id'] ?>" class="btn btn-primary btn-sm">عرض</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- آخر ملفات PDF -->
    <div class="card-glass mt-4">
        <h4 class="text-white mb-3">📄 آخر ملفات PDF</h4>
        <div class="table-responsive">
            <table class="table table-bordered align-middle text-center">
                <thead class="table-dark">
                    <tr>
                        <th>الطالب</th>
                        <th>اسم الملف</th>
                        <th>تاريخ الرفع</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(!$recent_pdfs): ?>
                        <tr><td colspan="3">لا يوجد ملفات</td></tr>
                    <?php else: ?>
                        <?php foreach ($recent_pdfs as $pd): ?>
                        <tr>
                            <td><?= $pd['student_id'] ?></td>
                            <td><?= htmlspecialchars($pd['pdf_name']) ?></td>
                            <td><?= $pd['uploaded_at'] ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>
</div>

<?php include "includes/footer.php"; ?>
