<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

$msg = "";

if ($_SERVER['REQUEST_METHOD']=="POST") {

    $label = sanitize($_POST['label']);
    $name = sanitize($_POST['name']);
    $type = sanitize($_POST['type']);
    $required = isset($_POST['required']) ? 1 : 0;
    $section = sanitize($_POST['section']);
    $options = $_POST['options'] ?? "";

    $stmt = $conn->prepare("
        INSERT INTO fields (field_name, field_label, field_type, is_required, show_in_pdf, show_in_dashboard, order_number, section_name, options)
        VALUES (?,?,?,?,1,1,999,?,?)
    ");
    $stmt->execute([$name,$label,$type,$required,$section,$options]);

    $msg = "✔ تمت الإضافة بنجاح";
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إضافة حقل</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#0f172a; color:white; font-family:Tajawal; }
.glass { background:rgba(255,255,255,0.08); padding:25px;border-radius:15px;border:1px solid rgba(255,255,255,0.2);}
</style>
</head>
<body>

<div class="container mt-4">
<div class="glass">

<h3>➕ إضافة حقل</h3>

<?php if ($msg): ?>
<div class="alert alert-success text-center"><?= $msg ?></div>
<?php endif; ?>

<form method="POST">

<label>اسم العرض</label>
<input name="label" class="form-control mb-2" required>

<label>اسم العمود (SQL)</label>
<input name="name" class="form-control mb-2" required>

<label>نوع الحقل</label>
<select name="type" class="form-control mb-2">
    <option value="text">نص</option>
    <option value="number">رقم</option>
    <option value="date">تاريخ</option>
    <option value="textarea">مربع نص</option>
    <option value="select">قائمة</option>
    <option value="radio">Radio</option>
    <option value="checkbox">Checkbox</option>
</select>

<label>موقع الحقل داخل الاستمارة</label>
<select name="section" class="form-control mb-2">
    <option value="personal">المعلومات الشخصية</option>
    <option value="school">معلومات المدرسة</option>
    <option value="college">معلومات الكلية</option>
    <option value="system">بيانات النظام</option>
    <option value="extra">ملاحظات إضافية</option>
    <option value="custom">قسم خاص</option>
</select>

<label>خيارات (للحقل select/radio)</label>
<textarea name="options" class="form-control mb-2" placeholder="اكتب الخيارات مفصولة بفاصلة"></textarea>

<label>
<input type="checkbox" name="required"> حقل مطلوب
</label>

<br><br>
<button class="btn btn-primary">حفظ</button>

</form>

</div></div>

</body>
</html>
