<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) { header("Location: ../login.php"); exit; }

$id = intval($_GET['id']);

$field = $conn->query("SELECT * FROM fields WHERE id=$id")->fetch(PDO::FETCH_ASSOC);

if (!$field) die("Field not found!");

$msg = "";

if ($_SERVER["REQUEST_METHOD"]=="POST") {

    $label = sanitize($_POST['label']);
    $name  = sanitize($_POST['name']);
    $type  = sanitize($_POST['type']);
    $required = isset($_POST['required']) ? 1 : 0;
    $section  = sanitize($_POST['section']);
    $options = $_POST['options'] ?? "";

    $stmt = $conn->prepare("
        UPDATE fields SET field_name=?, field_label=?, field_type=?, is_required=?, section_name=?, options=?
        WHERE id=?
    ");
    $stmt->execute([$name,$label,$type,$required,$section,$options,$id]);

    $msg = "✔ تم التحديث";
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل حقل</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#0f172a; color:white; font-family:Tajawal; }
.glass {background:rgba(255,255,255,0.1);padding:25px;border-radius:14px;}
</style>
</head>
<body>

<div class="container mt-4"><div class="glass">

<h3>✏ تعديل حقل</h3>

<?php if ($msg): ?>
<div class="alert alert-success text-center"><?= $msg ?></div>
<?php endif; ?>

<form method="POST">

<label>اسم العرض</label>
<input name="label" value="<?= $field['field_label'] ?>" class="form-control mb-2">

<label>اسم العمود (SQL)</label>
<input name="name" value="<?= $field['field_name'] ?>" class="form-control mb-2">

<label>نوع الحقل</label>
<select name="type" class="form-control mb-2">
    <option <?= $field['field_type']=="text"?"selected":"" ?>>text</option>
    <option <?= $field['field_type']=="number"?"selected":"" ?>>number</option>
    <option <?= $field['field_type']=="date"?"selected":"" ?>>date</option>
    <option <?= $field['field_type']=="textarea"?"selected":"" ?>>textarea</option>
    <option <?= $field['field_type']=="select"?"selected":"" ?>>select</option>
    <option <?= $field['field_type']=="radio"?"selected":"" ?>>radio</option>
    <option <?= $field['field_type']=="checkbox"?"selected":"" ?>>checkbox</option>
</select>

<label>موقع الحقل داخل الاستمارة</label>
<select name="section" class="form-control mb-2">
    <option <?= $field['section_name']=="personal"?"selected":"" ?> value="personal">المعلومات الشخصية</option>
    <option <?= $field['section_name']=="school"?"selected":"" ?> value="school">معلومات المدرسة</option>
    <option <?= $field['section_name']=="college"?"selected":"" ?> value="college">معلومات الكلية</option>
    <option <?= $field['section_name']=="system"?"selected":"" ?> value="system">بيانات النظام</option>
    <option <?= $field['section_name']=="extra"?"selected":"" ?> value="extra">ملاحظات إضافية</option>
    <option <?= $field['section_name']=="custom"?"selected":"" ?> value="custom">قسم خاص</option>
</select>

<label>خيارات</label>
<textarea name="options" class="form-control mb-2"><?= $field['options'] ?></textarea>

<label><input type="checkbox" name="required" <?= $field['is_required'] ? "checked":"" ?>> مطلوب</label>

<br><br>
<button class="btn btn-primary">تحديث</button>

</form>

</div></div>
</body>
</html>
