<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

$fields = $conn->query("SELECT * FROM fields ORDER BY order_number ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة الحقول</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body { background:#0f172a; color:white; font-family:Tajawal; }
.glass { background:rgba(255,255,255,0.08); padding:20px; border-radius:12px;
        border:1px solid rgba(255,255,255,0.25); }
.table td, .table th { color:white; }
</style>
</head>
<body>

<div class="container mt-4">
<div class="glass">

<div class="d-flex justify-content-between mb-3">
    <h4>حقول التسجيل</h4>
    <a href="add.php" class="btn btn-primary">➕ إضافة حقل</a>
</div>

<table class="table table-bordered text-center">
<thead>
<tr>
    <th>الترتيب</th>
    <th>اسم الحقل</th>
    <th>نوع</th>
    <th>مطلوب؟</th>
    <th>مكانه</th>
    <th>SQL</th>
    <th>عمليات</th>
</tr>
</thead>

<tbody>
<?php if (count($fields)==0): ?>
<tr><td colspan="7">لا توجد حقول</td></tr>
<?php endif; ?>

<?php foreach ($fields as $f): ?>
<tr>
    <td><?= $f['order_number'] ?></td>
    <td><?= htmlspecialchars($f['field_label']) ?></td>
    <td><?= $f['field_type'] ?></td>
    <td><?= $f['is_required'] ? "✔" : "❌" ?></td>
    <td><?= $f['section_name'] ?></td>
    <td><code><?= $f['field_name'] ?></code></td>

    <td>
        <a href="edit.php?id=<?= $f['id'] ?>" class="btn btn-warning btn-sm">تعديل</a>
        <a href="delete.php?id=<?= $f['id'] ?>" class="btn btn-danger btn-sm"
           onclick="return confirm('حذف الحقل؟');">حذف</a>
    </td>
</tr>
<?php endforeach; ?>
</tbody>

</table>

<div class="text-center mt-3">
    <a href="reorder.php" class="btn btn-info">🔀 ترتيب الحقول</a>
</div>

</div>
</div>

</body>
</html>
