<?php
if (!isset($_SESSION)) session_start();
require_once __DIR__ . "/../../config/app.php";
?>

<div class="app-navbar">
    <nav class="navbar navbar-expand-lg navbar-dark container-fluid px-3">
        
        <!-- Brand / Logo -->
        <a class="navbar-brand d-flex align-items-center gap-2" href="<?= base_url('admin/dashboard.php') ?>">
            <div class="bg-light d-flex align-items-center justify-content-center rounded-3" style="width:42px;height:42px;">
                <img src="<?= base_url('assets/images/logo.png') ?>" alt="Logo" style="max-width:80%;max-height:80%;border-radius:10px;">
            </div>
            <div class="d-flex flex-column">
                <span class="fw-bold small text-white-50">لوحة إدارة</span>
                <span class="fw-semibold">جامعة النبراس – مدير التسجيل</span>
            </div>
        </a>

        <!-- Toggler موبايل -->
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar"
                aria-controls="mainNavbar" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="mainNavbar">

            <!-- روابط أساسية / وسط النافبار -->
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">

                <!-- Dashboard -->
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/dashboard.php') ?>">
                        <i class="bi bi-speedometer2 me-1"></i> لوحة التحكم
                    </a>
                </li>

                <!-- الطلاب -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="studentsMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-people-fill me-1"></i> الطلاب
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="studentsMenu">
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/students.php') ?>">
                                <i class="bi bi-list-ul me-1"></i> قائمة الطلاب
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/add_student.php') ?>">
                                <i class="bi bi-person-plus me-1"></i> إضافة طالب
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/students_dorm.php') ?>">
                                <i class="bi bi-house-door-fill me-1"></i> سكن الطلاب
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- الحقول -->
                 <!--  <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="fieldsMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-ui-checks-grid me-1"></i> حقول التسجيل
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="fieldsMenu">
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/fields/list.php') ?>"> -->
                        <!--        <i class="bi bi-card-list me-1"></i> عرض الحقول
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href=" <!--<?= base_url('admin/fields/add.php') ?>"> -->
                        <!--        <i class="bi bi-plus-circle me-1"></i> إضافة حقل
                            </a>
                        </li>
                    </ul>
                </li> -->

                <!-- الكليات -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="collegesMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-building me-1"></i> الكليات
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="collegesMenu">
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/colleges/list.php') ?>">
                                <i class="bi bi-columns-gap me-1"></i> عرض الكليات
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/colleges/add.php') ?>">
                                <i class="bi bi-plus-circle-dotted me-1"></i> إضافة كلية
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- قنوات التقديم -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="channelsMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-diagram-3 me-1"></i> قنوات التقديم
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="channelsMenu">
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/channels/list.php') ?>">
                                <i class="bi bi-list-task me-1"></i> عرض القنوات
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/channels/add.php') ?>">
                                <i class="bi bi-node-plus me-1"></i> إضافة قناة
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- الإعدادات -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="settingsMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-gear-fill me-1"></i> الإعدادات
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="settingsMenu">
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/settings/general.php') ?>">
                                <i class="bi bi-sliders me-1"></i> الإعدادات العامة
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/settings/pdf_settings.php') ?>">
                                <i class="bi bi-filetype-pdf me-1"></i> إعدادات PDF
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/settings/whatsapp_templates.php') ?>">
                                <i class="bi bi-whatsapp me-1"></i> قوالب واتساب
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/settings/builder_settings.php') ?>">
                                <i class="bi bi-braces-asterisk me-1"></i> إعدادات Builder
                            </a>
                        </li>
                        <!--  <li>
                            <a class="dropdown-item" href="<?= base_url('admin/settings/backup_settings.php') ?>">
                                <i class="bi bi-hdd-network me-1"></i> إعدادات النسخ الاحتياطي
                            </a>
                        </li>-->
                        <li>
                            <a class="dropdown-item" href="<?= base_url('admin/settings/appearance.php') ?>">
                                <i class="bi bi-palette me-1"></i> المظهر
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- النسخ الاحتياطي -->
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/backups/list.php') ?>">
                        <i class="bi bi-hdd-stack me-1"></i> النسخ الاحتياطية
                    </a>
                </li>

                <!-- المستخدمون -->
                <li class="nav-item">
                    <a class="nav-link" href="<?= base_url('admin/users.php') ?>">
                        <i class="bi bi-person-gear me-1"></i> إدارة المستخدمين
                    </a>
                </li>

                <!-- الحسابات -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="financeMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-cash-stack me-1"></i> الحسابات
                    </a>
                    <ul class="dropdown-menu dropdown-menu-dark border-0 shadow" aria-labelledby="financeMenu">
                        <li>
                            <a class="dropdown-item" href="<?= base_url('tab/dashboard.php') ?>">
                                <i class="bi bi-speedometer me-1"></i> لوحة الحسابات
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?= base_url('tab/late_payments.php') ?>">
                                <i class="bi bi-alarm-exclamation me-1"></i> المتأخرون عن السداد
                            </a>
                        </li>
                    </ul>
                </li>

            </ul>

            <!-- يمين النافبار (روابط سريعة + خروج) -->
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center">

                <!-- الموقع العام -->
                <li class="nav-item me-lg-2 mb-1 mb-lg-0">
                    <a href="<?= base_url('index.php') ?>" target="_blank" class="btn btn-soft btn-sm d-flex align-items-center">
                        <i class="bi bi-globe2 me-1"></i>
                        <span>الموقع العام</span>
                    </a>
                </li>

                <!-- لوحة الرئيس (إبقاء زر مشاهدة الرئيس) -->
                <li class="nav-item me-lg-2 mb-1 mb-lg-0">
                    <a href="<?= base_url('president/dashboard.php?key=a') ?>" target="_blank"
                       class="btn btn-warning btn-sm d-flex align-items-center fw-semibold">
                        <i class="bi bi-eye-fill me-1"></i>
                        <span>عرض لوحة الرئيس</span>
                    </a>
                </li>

                <!-- Logout -->
                <li class="nav-item">
                    <a href="<?= base_url('admin/logout.php') ?>"
                       class="btn btn-danger btn-sm d-flex align-items-center px-3">
                        <i class="bi bi-door-open me-1"></i>
                        <span>تسجيل خروج</span>
                    </a>
                </li>

            </ul>

        </div>
    </nav>
</div>