<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";
require_once "../../config/app.php";

guard_admin();

// جلب قيمة إعداد
function get_app_set($key, $default="") {
    global $conn;
    $stmt = $conn->prepare("SELECT key_value FROM appearance_settings WHERE key_name=? LIMIT 1");
    $stmt->execute([$key]);
    $val = $stmt->fetchColumn();
    return $val ? $val : $default;
}

$success = "";
$error   = "";

// حفظ الإعدادات
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    foreach ($_POST as $key => $value) {
        $stmt = $conn->prepare("
            INSERT INTO appearance_settings (key_name, key_value)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE key_value=VALUES(key_value)
        ");
        $stmt->execute([$key, sanitize($value)]);
    }

    // رفع الخلفية
    if (!empty($_FILES['bg_image']['name'])) {

        $ext = strtolower(pathinfo($_FILES['bg_image']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','webp'];

        if (!in_array($ext, $allowed)) {
            $error = "❌ فقط JPG - PNG - WEBP مسموح";
        } else {

            $filename = "background." . $ext;
            $path = "../../assets/images/" . $filename;

            move_uploaded_file($_FILES['bg_image']['tmp_name'], $path);

            $stmt = $conn->prepare("
                INSERT INTO appearance_settings (key_name, key_value)
                VALUES ('background_image', ?)
                ON DUPLICATE KEY UPDATE key_value=VALUES(key_value)
            ");
            $stmt->execute([$filename]);
        }
    }

    if (!$error) {
        $success = "✔ تم حفظ إعدادات المظهر بنجاح!";
    }
}

// تحميل القيم
$current_mode      = get_app_set("mode", "dark");
$primary_color     = get_app_set("primary_color", "#6366f1");
$secondary_color   = get_app_set("secondary_color", "#3b82f6");
$bg_color          = get_app_set("bg_color", "#0f172a");
$bg_opacity        = get_app_set("bg_opacity", "0.12");
$glass_blur        = get_app_set("glass_blur", "12");
$font_family       = get_app_set("font_family", "Tajawal");
$bg_image          = get_app_set("background_image", "");

// عنوان الصفحة
$page_title = "إعدادات المظهر - Appearance";

// الهيدر (يحتوي navbar + sidebar)
require_once "../includes/header.php";
?>

<style>
body {
    background:#0f172a;
    font-family:"Tajawal";
    color:white;
}
.main-content {
    padding:25px;
}

.glass-box {
    max-width:950px;
    margin:20px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.15);
    box-shadow:0 15px 40px rgba(0,0,0,0.45);
}

label { font-weight:700; margin-bottom:6px; }

.form-control {
    background:rgba(255,255,255,0.12);
    border:1px solid rgba(255,255,255,0.25);
    border-radius:12px;
    color:white;
}

input[type="color"] {
    padding:0;
    border-radius:10px;
    border:none;
    width:100%;
    height:50px;
}

.bg-preview {
    width:100%;
    height:220px;
    border-radius:16px;
    background-size:cover;
    background-position:center;
    margin-bottom:12px;
    border:1px solid rgba(255,255,255,0.3);
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    color:white;
    padding:14px;
    border-radius:12px;
    width:100%;
    font-size:17px;
    font-weight:700;
}

.success-box {
    background:rgba(16,185,129,0.25);
    color:#bbf7d0;
    border:1px solid rgba(16,185,129,0.4);
    padding:12px;
    border-radius:12px;
    text-align:center;
}

.error-box {
    background:rgba(239,68,68,0.25);
    color:#fecaca;
    border:1px solid rgba(239,68,68,0.4);
    padding:12px;
    border-radius:12px;
    text-align:center;
}
</style>
<?php include "../includes/header.php"; ?>

<?php include "../includes/navbar.php"; ?>
<div class="main-content">

<div class="glass-box">

    <h3 class="mb-4">🎨 إعدادات المظهر (Appearance Settings)</h3>

    <?php if ($success): ?>
        <div class="success-box mb-3"><?= $success ?></div>
    <?php endif; ?>

    <?php if ($error): ?>
        <div class="error-box mb-3"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST" enctype="multipart/form-data">

        <!-- الوضع -->
        <div class="mb-4">
            <label>الوضع العام</label>
            <select name="mode" class="form-control">
                <option value="dark" <?= $current_mode=="dark"?"selected":"" ?>>🌙 الوضع الداكن</option>
                <option value="light" <?= $current_mode=="light"?"selected":"" ?>>☀️ الوضع الفاتح</option>
                <option value="auto" <?= $current_mode=="auto"?"selected":"" ?>>⚡ تلقائي</option>
            </select>
        </div>

        <!-- الألوان -->
        <div class="row mb-4">
            <div class="col-md-6">
                <label>اللون الرئيسي Primary</label>
                <input type="color" name="primary_color" value="<?= $primary_color ?>">
            </div>
            <div class="col-md-6">
                <label>اللون الثانوي Secondary</label>
                <input type="color" name="secondary_color" value="<?= $secondary_color ?>">
            </div>
        </div>

        <div class="mb-4">
            <label>لون الخلفية Background</label>
            <input type="color" name="bg_color" value="<?= $bg_color ?>">
        </div>

        <!-- خلفية -->
        <div class="mb-4">
            <label>رفع صورة خلفية (اختياري)</label>
            <input type="file" name="bg_image" class="form-control">
        </div>

        <?php if ($bg_image): ?>
            <div class="bg-preview" style="background-image:url('../../assets/images/<?= $bg_image ?>');"></div>
        <?php endif; ?>

        <!-- الشفافية والبلور -->
        <div class="row mb-4">
            <div class="col-md-6">
                <label>شفافية الواجهة (0 - 1)</label>
                <input type="number" step="0.01" name="bg_opacity" class="form-control" value="<?= $bg_opacity ?>">
            </div>
            <div class="col-md-6">
                <label>درجة الـ Blur</label>
                <input type="number" name="glass_blur" class="form-control" value="<?= $glass_blur ?>">
            </div>
        </div>

        <!-- الخط -->
        <div class="mb-4">
            <label>نوع الخط</label>
            <select name="font_family" class="form-control">
                <option value="Tajawal" <?= $font_family=="Tajawal"?"selected":"" ?>>Tajawal</option>
                <option value="Cairo" <?= $font_family=="Cairo"?"selected":"" ?>>Cairo</option>
                <option value="IBM Plex Sans Arabic" <?= $font_family=="IBM Plex Sans Arabic"?"selected":"" ?>>IBM Plex Arabic</option>
                <option value="Noto Kufi Arabic" <?= $font_family=="Noto Kufi Arabic"?"selected":"" ?>>Noto Kufi</option>
            </select>
        </div>

        <button class="btn-main mt-4">💾 حفظ الإعدادات</button>

    </form>

</div>

</div>

<?php require_once "../includes/footer.php"; ?>