<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// جلب الإعداد
function get_backup_setting($key, $default="") {
    global $conn;
    $stmt = $conn->prepare("SELECT key_value FROM backup_settings WHERE key_name=? LIMIT 1");
    $stmt->execute([$key]);
    $r = $stmt->fetchColumn();
    return $r ? $r : $default;
}

$success = "";

// حفظ الإعدادات
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    foreach ($_POST as $key => $value) {

        $stmt = $conn->prepare("
            INSERT INTO backup_settings (key_name, key_value)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE key_value=VALUES(key_value)
        ");

        $stmt->execute([$key, $value]);
    }

    $success = "✔ تم حفظ إعدادات النسخ الاحتياطي بنجاح!";
}

// تحميل الإعدادات الحالية
$backup_enabled      = get_backup_setting("backup_enabled", "1");
$backup_time         = get_backup_setting("backup_time", "03:00");
$google_folder_id    = get_backup_setting("google_folder_id", "");
$google_credentials  = get_backup_setting("google_credentials", "");
$retention_limit     = get_backup_setting("retention_limit", "30");
$auto_cleanup        = get_backup_setting("auto_cleanup", "1");

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إعدادات النسخة الاحتياطية</title>

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<style>

body {
    background:#0f172a;
    font-family:"Tajawal";
    color:white;
}

.glass-box {
    max-width:900px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.18);
    box-shadow:0 15px 45px rgba(0,0,0,0.45);
}

label { font-weight:600; }

textarea, .form-control {
    background:rgba(255,255,255,0.12);
    color:white;
    border:1px solid rgba(255,255,255,0.25);
    border-radius:12px;
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    padding:12px;
    border:0;
    width:100%;
    color:white;
    font-weight:700;
    border-radius:12px;
}

.success-box {
    background:rgba(16,185,129,0.25);
    padding:12px;border-radius:12px;
    color:#bbf7d0;
    border:1px solid rgba(16,185,129,0.4);
}

.note {
    color:#cbd5e1;
    font-size:13px;
}

</style>

</head>
<body>

<?php include "../includes/header.php"; ?>

<?php include "../includes/navbar.php"; ?>

<div class="main-content">

<div class="glass-box">

    <h3 class="mb-4">🗄 إعدادات النسخة الاحتياطية</h3>

    <?php if ($success): ?>
        <div class="success-box mb-3"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST">

        <div class="mb-4">
            <label>تفعيل النسخ الاحتياطي اليومي</label>
            <select name="backup_enabled" class="form-control">
                <option value="1" <?= $backup_enabled=="1"?"selected":"" ?>>✔ مفعّل</option>
                <option value="0" <?= $backup_enabled=="0"?"selected":"" ?>>❌ متوقف</option>
            </select>
        </div>

        <div class="mb-4">
            <label>وقت تنفيذ النسخ الاحتياطي (يوميًا)</label>
            <input type="time" name="backup_time" class="form-control"
                   value="<?= $backup_time ?>">
            <div class="note mt-1">يُفضّل وقت منخفض الاستخدام مثل 03:00 صباحاً</div>
        </div>

        <div class="mb-4">
            <label>Google Drive Folder ID</label>
            <input type="text" name="google_folder_id" class="form-control"
                   value="<?= htmlspecialchars($google_folder_id) ?>">
            <div class="note mt-1">ضع معرف المجلد الذي يتم رفع النسخ إليه.</div>
        </div>

        <div class="mb-4">
            <label>Google API Credentials (JSON)</label>
            <textarea name="google_credentials" rows="6" class="form-control"><?= htmlspecialchars($google_credentials) ?></textarea>
            <div class="note mt-1">الصق محتوى الملف JSON كاملاً هنا.</div>
        </div>

        <div class="mb-4">
            <label>عدد الأيام التي يتم الاحتفاظ بالنسخ خلالها</label>
            <input type="number" name="retention_limit" class="form-control"
                   value="<?= $retention_limit ?>">
            <div class="note mt-1">مثال: 30 يعني حذف النسخ الأقدم من 30 يوم.</div>
        </div>

        <div class="mb-4">
            <label>حذف النسخ القديمة تلقائياً</label>
            <select name="auto_cleanup" class="form-control">
                <option value="1" <?= $auto_cleanup=="1"?"selected":"" ?>>✔ نعم</option>
                <option value="0" <?= $auto_cleanup=="0"?"selected":"" ?>>❌ لا</option>
            </select>
        </div>

        <button class="btn-main mt-4">💾 حفظ إعدادات النسخ الاحتياطية</button>

    </form>

</div>

</div>

<?php include "../includes/footer.php"; ?>

</body>
</html>
