<?php
session_start();
require_once "../../config/db.php";
require_once "../../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// جلب القالب
function get_template($key, $default="") {
    global $conn;
    $stmt = $conn->prepare("SELECT template_text FROM whatsapp_templates WHERE template_key=? LIMIT 1");
    $stmt->execute([$key]);
    $r = $stmt->fetchColumn();
    return $r ? $r : $default;
}

$success = "";

// عند الحفظ
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    foreach ($_POST as $key => $value) {

        $stmt = $conn->prepare("
            INSERT INTO whatsapp_templates (template_key, template_text)
            VALUES (?, ?)
            ON DUPLICATE KEY UPDATE template_text=VALUES(template_text)
        ");

        $stmt->execute([$key, $value]);
    }

    $success = "✔ تم حفظ القوالب بنجاح!";
}

// تحميل الرسائل الحالية
$templates = [
    "register_success"      => get_template("register_success", "عزيزي {{student_name}} تم استلام طلب تسجيلك في جامعة النبراس."),
    "verify_approved"       => get_template("verify_approved", "تم تدقيق طلبك بنجاح. رقمك الامتحاني: {{exam_number}}"),
    "payment_added"         => get_template("payment_added", "تم استلام دفعة بقيمة {{amount}}. المتبقي: {{remaining}}"),
    "due_reminder"          => get_template("due_reminder", "نذكرك بأن موعد استحقاق القسط سيكون بتاريخ {{due_date}}."),
    "due_date_changed"      => get_template("due_date_changed", "تم تغيير موعد استحقاق القسط الخاص بك إلى {{new_date}} بناءً على أمر الإدارة."),
    "pdf_ready"             => get_template("pdf_ready", "تم تجهيز الاستمارة الخاصة بك. يمكنك تحميلها الآن."),
    "general"               => get_template("general", "إشعار من جامعة النبراس: {{message}}")
];

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>قوالب رسائل واتساب</title>

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<style>

body {
    background:#0f172a;
    font-family:"Tajawal";
    color:white;
}

.glass-box {
    max-width:900px;
    margin:40px auto;
    background:rgba(255,255,255,0.07);
    padding:30px;
    border-radius:20px;
    border:1px solid rgba(255,255,255,0.18);
    box-shadow:0 15px 45px rgba(0,0,0,0.45);
}

label { font-weight:600; }

textarea.form-control {
    background:rgba(255,255,255,0.12);
    color:white;
    border:1px solid rgba(255,255,255,0.25);
    border-radius:12px;
    min-height:95px;
}

.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    padding:12px;
    border:0;
    width:100%;
    color:white;
    font-weight:700;
    border-radius:12px;
}

.success-box {
    background:rgba(16,185,129,0.25);
    padding:12px;border-radius:12px;
    color:#bbf7d0;
    border:1px solid rgba(16,185,129,0.4);
}

.template-title {
    font-size:18px;
    font-weight:700;
    margin-bottom:10px;
    color:#e0e7ff;
}

.tip {
    font-size:13px;
    color:#cbd5e1;
}

</style>

</head>
<body>

<?php include "../includes/header.php"; ?>

<?php include "../includes/navbar.php"; ?>

<div class="main-content">

<div class="glass-box">
    
    <h3 class="mb-4">💬 قوالب رسائل واتساب</h3>

    <?php if ($success): ?>
        <div class="success-box mb-3"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST">

        <?php foreach ($templates as $key => $val): ?>
        
            <div class="mb-4">
                <div class="template-title">
                    <?= strtoupper(str_replace("_"," ",$key)) ?>
                </div>

                <textarea name="<?= $key ?>" class="form-control"><?= htmlspecialchars($val) ?></textarea>

                <div class="tip mt-1">
                    المتغيرات المسموحة:  
                    {{student_name}}, 
                    {{exam_number}}, 
                    {{amount}}, 
                    {{remaining}}, 
                    {{due_date}}, 
                    {{new_date}}, 
                    {{message}}
                </div>
            </div>

        <?php endforeach; ?>

        <button class="btn-main mt-4">💾 حفظ القوالب</button>

    </form>

</div>

</div>

<?php include "../includes/footer.php"; ?>

</body>
</html>
