<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("❌ خطأ: لا يوجد معرف للطالب.");
}

$id = intval($_GET['id']);

/*=============================
   جلب بيانات الطالب
=============================*/

$stmt = $conn->prepare("SELECT student_photo FROM students WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("❌ الطالب غير موجود.");
}

/*=============================
   حذف صورة الطالب
=============================*/
if (!empty($student['student_photo'])) {
    $path = "../uploads/student_photos/" . $student['student_photo'];
    if (file_exists($path)) {
        unlink($path);
    }
}

/*=============================
   حذف ملف PDF إذا كان مخزون
=============================*/
$pdf = $conn->prepare("SELECT pdf_path FROM student_pdf WHERE student_id=? LIMIT 1");
$pdf->execute([$id]);
$pdf_row = $pdf->fetch(PDO::FETCH_ASSOC);

if ($pdf_row && !empty($pdf_row['pdf_path'])) {
    $pdfPath = "../" . $pdf_row['pdf_path'];
    if (file_exists($pdfPath)) {
        unlink($pdfPath);
    }

    // حذف من جدول student_pdf
    $del_pdf = $conn->prepare("DELETE FROM student_pdf WHERE student_id=?");
    $del_pdf->execute([$id]);
}

/*=============================
   حذف الطالب نهائياً
=============================*/
$delete = $conn->prepare("DELETE FROM students WHERE id=?");
$delete->execute([$id]);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>حذف الطالب</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

<style>
body {
    background: radial-gradient(circle at top, #0f172a,#1e1b4b);
    color:white;
    font-family:"Tajawal";
    display:flex;
    align-items:center;
    justify-content:center;
    height:100vh;
}

.delete-box {
    background:rgba(220,38,38,0.18);
    border:1px solid rgba(220,38,38,0.35);
    padding:30px 45px;
    border-radius:18px;
    text-align:center;
    box-shadow:0 10px 35px rgba(0,0,0,0.5);
}

.delete-box h2 {
    font-size:24px;
    font-weight:800;
    color:#fecaca;
}
.delete-box p {
    font-size:15px;
    color:#ffe4e6;
}
.btn-back {
    margin-top:20px;
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    padding:12px 30px;
    border-radius:12px;
    color:white;
    font-weight:700;
}
</style>

<meta http-equiv="refresh" content="2; URL=students.php" />

</head>
<body>

<div class="delete-box">
    <h2>✔ تم حذف الطالب بنجاح</h2>
    <p>إعادة التوجيه إلى قائمة الطلاب...</p>

    <a href="students.php" class="btn-back">الرجوع immediately</a>
</div>

</body>
</html>