<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";


// حماية الدخول
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

// التحقق من وجود ID
$id = intval($_GET['id']);

// جلب بيانات الطالب
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$student) {
    die("❌ الطالب غير موجود.");
}

// جلب الأقسام
$colleges = $conn->query("SELECT college_name, fee FROM colleges ORDER BY college_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// جلب قنوات التقديم
$channels = $conn->query("SELECT channel_name FROM channels ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

// عند حفظ التعديل
$success = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // استقبال القيم
    $full_name      = sanitize($_POST['full_name']);
    $mother_name    = sanitize($_POST['mother_name']);
    $phone          = sanitize($_POST['phone']);
    $email          = sanitize($_POST['email']);
    $national_or_passport = sanitize($_POST['national_or_passport']);
    $birth_place    = sanitize($_POST['birth_place']);
    $address        = sanitize($_POST['address']);
    $nearest_point  = sanitize($_POST['nearest_point']);
    $gender         = sanitize($_POST['gender']);
    $guardian_phone1 = sanitize($_POST['guardian_phone1']);

    // المدرسة
    $school_name    = sanitize($_POST['school_name']);
    $branch         = sanitize($_POST['branch']);
    $graduation_year = sanitize($_POST['graduation_year']);
    $exam_round     = sanitize($_POST['exam_round']);
    $attempts       = sanitize($_POST['attempts']);
    $fail_years     = sanitize($_POST['fail_years']);
    $exam_number    = sanitize($_POST['exam_number']);
    $average        = sanitize($_POST['average']);

    // الكلية / القسم
    $college_name   = sanitize($_POST['college_name']);
    $study_type     = sanitize($_POST['study_type']);
    $admission_channel = sanitize($_POST['admission_channel']);
    $college_fee    = intval($_POST['college_fee']);

    // النظام
    $app_username   = sanitize($_POST['app_username']);
    $app_password   = sanitize($_POST['app_password']);
    $dorm_request   = sanitize($_POST['dorm_request']);

    // ⚠ لا نغير حالة الطالب أبداً — يعرض فقط
    $status         = $student['status'];

    // صورة الطالب
    $student_photo = $student['student_photo'];
    if (!empty($_FILES['student_photo']['name'])) {
        $student_photo = "student_" . time() . ".jpg";
        move_uploaded_file($_FILES['student_photo']['tmp_name'], "../uploads/student_photos/" . $student_photo);
    }

    // تحديث البيانات
    $update = $conn->prepare("
        UPDATE students SET
        full_name=?, national_or_passport=?, phone=?, email=?, mother_name=?, birth_place=?, address=?, nearest_point=?, gender=?, guardian_phone1=?,
        school_name=?, branch=?, graduation_year=?, exam_round=?, attempts=?, fail_years=?, exam_number=?, average=?,
        college_name=?, study_type=?, admission_channel=?, college_fee=?,
        app_username=?, app_password=?, dorm_request=?, status=?, student_photo=?
        WHERE id=?
    ");

    $update->execute([
        $full_name, $national_or_passport, $phone, $email, $mother_name, $birth_place, $address, $nearest_point, $gender, $guardian_phone1,
        $school_name, $branch, $graduation_year, $exam_round, $attempts, $fail_years, $exam_number, $average,
        $college_name, $study_type, $admission_channel, $college_fee,
        $app_username, $app_password, $dorm_request, $status, $student_photo,
        $id
    ]);

    $success = "✔ تم تحديث بيانات الطالب بنجاح.";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل بيانات الطالب</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

<style>
body {
    background: radial-gradient(circle at top, #0f172a, #1e1b4b);
    color:white;
    font-family:"Tajawal";
}
.navbar-custom {
    background: linear-gradient(90deg,#1e293b,#4338ca);
    padding:14px 20px;
    display:flex;
    align-items:center;
}
.navbar-custom img {
    width:50px;height:50px;border-radius:12px;background:#fff;
}
.navbar-custom .title {
    font-size:22px;font-weight:700;margin-right:15px;
}
.glass-form {
    max-width:1100px;
    margin:30px auto;
    background:rgba(255,255,255,0.06);
    padding:30px;
    border-radius:18px;
    border:1px solid rgba(255,255,255,0.15);
    box-shadow:0 15px 45px rgba(0,0,0,0.45);
}
.section-title {
    font-size:22px;
    font-weight:700;
    margin:20px 0 10px;
    color:#93c5fd;
}
.form-label { color:#c7d2fe;font-weight:600; }
.form-control, select {
    background:rgba(255,255,255,0.15) !important;
    border:1px solid rgba(255,255,255,0.2);
    color:white !important;
    border-radius:10px;
}
.btn-main {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;padding:10px 20px;
    border-radius:12px;
    font-size:17px;font-weight:700;color:white;
}
.success-box {
    background:rgba(16,185,129,0.25);
    border:1px solid rgba(16,185,129,0.4);
    padding:12px;border-radius:12px;
    color:#bbf7d0;
    margin-bottom:20px;
    text-align:center;
}
.status-box {
    background:rgba(59,130,246,0.2);
    border:1px solid rgba(59,130,246,0.4);
    padding:10px;
    border-radius:12px;
    margin-top:10px;
    text-align:center;
    font-weight:700;
}
</style>

</head>
<body>

<div class="navbar-custom">
    
    <img src="../assets/images/logo.png">
    <div class="title">تعديل بيانات الطالب</div>
</div>

<div class="glass-form">

    <?php if ($success): ?>
        <div class="success-box"><?= $success ?></div>
    <?php endif; ?>

    <!-- ⚠ عرض حالة الطالب فقط -->
    <div class="status-box">
        حالة الطالب الحالية:  
        <?= ($student['status']=="pending"?"بانتظار التدقيق":
             ($student['status']=="verified"?"تم التدقيق":"الطالب مقبول")) ?>
    </div>

    <form method="POST" enctype="multipart/form-data">

        <!-- المعلومات الشخصية -->
        <div class="section-title">🧍 المعلومات الشخصية</div>
        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">الاسم الرباعي واللقب</label>
                <input type="text" name="full_name" class="form-control" value="<?= $student['full_name'] ?>" required>
            </div>

            <div class="col-md-6">
                <label class="form-label">اسم الأم</label>
                <input type="text" name="mother_name" class="form-control" value="<?= $student['mother_name'] ?>" required>
            </div>

            <div class="col-md-4">
                <label class="form-label">رقم الهاتف</label>
                <input type="text" name="phone" class="form-control" value="<?= $student['phone'] ?>" required>
            </div>

            <div class="col-md-4">
                <label class="form-label">رقم ولي الأمر</label>
                <input type="text" name="guardian_phone1" class="form-control" value="<?= $student['guardian_phone1'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">الجنس</label>
                <select name="gender" class="form-control">
                    <option <?= $student['gender']=="ذكر"?"selected":"" ?>>ذكر</option>
                    <option <?= $student['gender']=="أنثى"?"selected":"" ?>>أنثى</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">البريد الإلكتروني</label>
                <input type="email" name="email" class="form-control" value="<?= $student['email'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">رقم البطاقة الوطنية / الجواز</label>
                <input type="text" name="national_or_passport" class="form-control" value="<?= $student['national_or_passport'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">محل الولادة</label>
                <input type="text" name="birth_place" class="form-control" value="<?= $student['birth_place'] ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">العنوان</label>
                <input type="text" name="address" class="form-control" value="<?= $student['address'] ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">أقرب نقطة دالة</label>
                <input type="text" name="nearest_point" class="form-control" value="<?= $student['nearest_point'] ?>">
            </div>

            <div class="col-md-12">
                <label class="form-label">صورة الطالب</label>
                <input type="file" name="student_photo" class="form-control">
            </div>

        </div>

        <!-- المدرسة -->
        <div class="section-title">🏫 معلومات المدرسة</div>
        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">اسم المدرسة</label>
                <input type="text" name="school_name" class="form-control" value="<?= $student['school_name'] ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">الفرع</label>
                <input type="text" name="branch" class="form-control" value="<?= $student['branch'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">سنة التخرج</label>
                <input type="number" name="graduation_year" class="form-control" value="<?= $student['graduation_year'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">الدور</label>
                <select name="exam_round" class="form-control">
                    <option <?= $student['exam_round']=="الدور الاول"?"selected":"" ?>>الدور الاول</option>
                    <option <?= $student['exam_round']=="الدور الثاني"?"selected":"" ?>>الدور الثاني</option>
                    <option <?= $student['exam_round']=="الدور الثالث"?"selected":"" ?>>الدور الثالث</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">نظام المحاولات</label>
                <select name="attempts" class="form-control">
                    <option <?= $student['attempts']=="نعم"?"selected":"" ?>>نعم</option>
                    <option <?= $student['attempts']=="لا"?"selected":"" ?>>لا</option>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">سنوات الرسوب</label>
                <input type="number" name="fail_years" class="form-control" value="<?= $student['fail_years'] ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">الرقم الامتحاني</label>
                <input type="text" name="exam_number" class="form-control" value="<?= $student['exam_number'] ?>">
            </div>

            <div class="col-md-6">
                <label class="form-label">المعدل</label>
                <input type="text" name="average" class="form-control" value="<?= $student['average'] ?>">
            </div>

        </div>

        <!-- الكلية -->
        <div class="section-title">🏛️ الكلية / القسم</div>
        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label">القسم / الكلية</label>
                <select name="college_name" class="form-control" id="collegeSelect">
                    <?php foreach ($colleges as $c): ?>
                        <option 
                            value="<?= htmlspecialchars($c['college_name']) ?>"
                            data-fee="<?= $c['fee'] ?>"
                            <?= $student['college_name']==$c['college_name']?"selected":"" ?>
                        >
                            <?= htmlspecialchars($c['college_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">القسط السنوي</label>
                <input type="number" name="college_fee" id="collegeFee"
                       class="form-control"
                       value="<?= $student['college_fee'] ?>">
            </div>

            <script>
                document.getElementById('collegeSelect').addEventListener('change', function () {
                    let fee = this.options[this.selectedIndex].getAttribute('data-fee');
                    document.getElementById('collegeFee').value = fee;
                });
            </script>

            <div class="col-md-6">
                <label class="form-label">نوع الدراسة</label>
                <select name="study_type" class="form-control">
                    <option <?= $student['study_type']=="صباحي"?"selected":"" ?>>صباحي</option>
                    <option <?= $student['study_type']=="مسائي"?"selected":"" ?>>مسائي</option>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">قناة التقديم</label>
                <select name="admission_channel" class="form-control">
                    <?php foreach ($channels as $ch): ?>
                        <option <?= $student['admission_channel']==$ch['channel_name']?"selected":"" ?>>
                            <?= htmlspecialchars($ch['channel_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

        </div>

        <!-- النظام -->
        <div class="section-title">⚙️ بيانات النظام</div>
        <div class="row g-3">

            <div class="col-md-4">
                <label class="form-label">اسم المستخدم</label>
                <input type="text" name="app_username" class="form-control" value="<?= $student['app_username'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">كلمة المرور</label>
                <input type="text" name="app_password" class="form-control" value="<?= $student['app_password'] ?>">
            </div>

            <div class="col-md-4">
                <label class="form-label">السكن الداخلي</label>
                <select name="dorm_request" class="form-control">
                    <option <?= $student['dorm_request']=="نعم"?"selected":"" ?>>نعم</option>
                    <option <?= $student['dorm_request']=="كلا"?"selected":"" ?>>كلا</option>
                </select>
            </div>

        </div>

        <div class="text-center mt-4">
            <button class="btn-main">💾 حفظ التعديلات</button>
        </div>

    </form>

</div>

</body>
</html>