<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

if (!isset($_SESSION['admin_logged_in'])) {
    die("⚠️ Access Denied");
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid Student ID");
}

$id = intval($_GET['id']);

// ===============================
//  جلب بيانات الطالب
// ===============================
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$st = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$st) {
    die("🚫 Student not found");
}

$logo = "../assets/img/logo.png";

// ===============================
//  أقسام البيانات
// ===============================
$personal = [
    "رقم الهوية / الجواز" => $st["national_or_passport"],
    "الهاتف" => $st["phone"],
    "اسم الأم" => $st["mother_name"],
    "الجنس" => $st["gender"],
    "البريد الإلكتروني" => $st["email"],
    "مكان الولادة" => $st["birth_place"],
    "العنوان" => $st["address"],
    "أقرب نقطة دالة" => $st["nearest_point"]
];

$school = [
    "اسم المدرسة" => $st["school_name"],
    "الفرع" => $st["branch"],
    "سنة التخرج" => $st["graduation_year"],
    "الدور" => $st["exam_round"],
    "المحاولات" => $st["attempts"],
    "سنوات الرسوب" => $st["fail_years"],
    "الرقم الامتحاني" => $st["exam_number"],
    "عدد الدروس" => $st["subjects_count"],
    "المجموع" => $st["total_score"],
    "المعدل" => $st["average"]
];

$uni = [
    "اسم الجامعة" => $st["university_name"],
    "القسم" => $st["college_name"],
    "نوع الدراسة" => $st["study_type"],
    "قناة التقديم" => $st["admission_channel"],
    "القسط السنوي" => number_format((int)$st["college_fee"])
];

$sys = [
    "اسم المستخدم" => $st["app_username"],
    "كلمة المرور" => $st["app_password"],
    "سكن داخلي" => $st["dorm_request"],
    "حالة الطلب" => "مقبول من قبل التسجيل"
];

// ===============================
//      تنسيق PDF
// ===============================
function makeTable($title, $arr)
{
    $html = '<table class="table-box">
    <tr><th colspan="2" class="heading">'.$title.'</th></tr>';

    foreach ($arr as $label => $val) {

        // أرقام بدون فوارز (ماعدا القسط)
        if (is_numeric($val) && $label != "القسط السنوي") {
            $val = (string)((int)$val);
        }

        $html .= "
            <tr>
                <td class='label'>$label</td>
                <td class='value'>".htmlspecialchars($val)."</td>
            </tr>
        ";
    }

    $html .= "</table>";
    return $html;
}

// ===============================
//   الصفحة الأولى
// ===============================
$html1 = '
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">

<style>
body {
    font-family: "dejavu sans", "Tahoma";
    direction: rtl;
    font-size: 13px;
    margin: 0;
    padding: 0;
}

.title {
    text-align: center;
    font-size: 20px;
    margin-bottom: 10px;
}

.logo {
    display: block;
    margin: auto;
}

.table-box {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 18px;
    table-layout: fixed;
}

.table-box th, .table-box td {
    border: 1px solid #000;
    padding: 7px;
    word-wrap: break-word;
    white-space: normal;
    vertical-align: top;
}

.heading {
    background: #e3e8ef;
    font-weight: bold;
    text-align: center;
}

.label {
    width: 35%;
    background: #f1f5f9;
    font-weight: bold;
}

.value {
    width: 65%;
}
</style>

</head>
<body>

<div class="title">
    <img src="'.$logo.'" width="90" class="logo"><br>
    <strong>تقرير معلومات الطالب</strong><br>
    '.htmlspecialchars($st["full_name"]).'
</div>
';

// إضافة جداول الصفحة الأولى
$html1 .= makeTable("المعلومات الشخصية", $personal);
$html1 .= makeTable("المدرسة / الإعدادية", $school);
$html1 .= makeTable("الجامعة والكلية", $uni);

$html1 .= "</body></html>";

// ===============================
//   الصفحة الثانية (بيانات النظام)
// ===============================
$html2 = '
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head><meta charset="UTF-8"></head>
<body>';

$html2 .= makeTable("بيانات النظام", $sys);

$html2 .= "</body></html>";

// ===============================
//      تشغيل mPDF
// ===============================
require_once "../vendor/autoload.php";

$tempDir = __DIR__ . '/../tmp';
if (!file_exists($tempDir)) mkdir($tempDir, 0777, true);

$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'margin_top' => 10,
    'margin_bottom' => 10,
    'margin_left' => 10,
    'margin_right' => 10,
    'tempDir' => $tempDir
]);

// الصفحة الأولى
$mpdf->WriteHTML($html1);

// صفحة جديدة
$mpdf->AddPage();

// الصفحة الثانية
$mpdf->WriteHTML($html2);

// إخراج
$mpdf->Output("student_$id.pdf", "I");