<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

guard_admin();

// استلام الفلترة
$from_date = $_GET['from_date'] ?? '';
$to_date   = $_GET['to_date']   ?? '';

// بناء شرط التاريخ
$where = " WHERE dorm_request='نعم' ";
$params = [];

if (!empty($from_date)) {
    $where .= " AND DATE(created_at) >= :from_date ";
    $params[':from_date'] = $from_date;
}
if (!empty($to_date)) {
    $where .= " AND DATE(created_at) <= :to_date ";
    $params[':to_date'] = $to_date;
}

// إحصائيات السكن (حسب الفلتر)
$sqlCountBase = "SELECT 
    SUM(1) AS total_all,
    SUM(CASE WHEN gender='ذكر' THEN 1 ELSE 0 END) AS total_male,
    SUM(CASE WHEN gender='أنثى' THEN 1 ELSE 0 END) AS total_female
    FROM students
    $where
";

$stmtCount = $conn->prepare($sqlCountBase);
$stmtCount->execute($params);
$stats = $stmtCount->fetch(PDO::FETCH_ASSOC);

$total_dorm   = $stats['total_all']   ?? 0;
$total_male   = $stats['total_male']  ?? 0;   // ← تم إصلاح الخطأ هنا
$total_female = $stats['total_female']?? 0;

// جلب البيانات
$sql = "
    SELECT id, full_name, college_name, phone, gender, birth_place, address, nearest_point, guardian_phone1, created_at
    FROM students
    $where
    ORDER BY id DESC
";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);



// تحميل الهيدر + النافبار
require_once "includes/header.php";
require_once "includes/navbar.php";
// عنوان الصفحة

?>

<style>
/* نفس التصميم الأصلي 100% بدون أي تغيير */
body {
    background:#0f172a;
    color:white;
    font-family:"Tajawal";
}

.page-title {
    text-align:center;
    margin-bottom:25px;
    font-size:28px;
    font-weight:700;
    color:#fff;
}

.card-glass {
    background:rgba(255,255,255,0.07);
    border:1px solid rgba(255,255,255,0.1);
    backdrop-filter:blur(12px);
    border-radius:18px;
    padding:25px;
}

.stat-box {
    padding:20px;
    border-radius:16px;
    background:rgba(255,255,255,0.08);
    text-align:center;
    color:white;
}

.stat-box h3 {
    font-size:26px;
    font-weight:700;
}

.stat-box span {
    font-size:14px;
    opacity:.8;
}

.table thead {
    background:#1e293b;
    color:white;
    font-size:15px;
}

.btn-action {
    padding:4px 6px;
    font-size:13px;
    border-radius:8px;
}

.filter-label {
    font-size:14px;
    margin-bottom:4px;
    color:#e5e7eb;
}

@media print {
    .actions-col {
        display:none !important;
    }
}
</style>

<div class="page-content container-fluid mt-4">

<h2 class="page-title">🏨 نظام السكن الداخلي – جامعة النبراس</h2>

<!-- الإحصائيات -->
<div class="row g-3 mb-4">

    <div class="col-md-4">
        <div class="stat-box">
            <h3><?= number_format((int)$total_dorm) ?></h3>
            <span>إجمالي ساكني الأقسام الداخلية (حسب الفترة)</span>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-box">
            <h3><?= number_format((int)$total_male) ?></h3>
            <span>عدد الذكور</span>
        </div>
    </div>

    <div class="col-md-4">
        <div class="stat-box">
            <h3><?= number_format((int)$total_female) ?></h3>
            <span>عدد الإناث</span>
        </div>
    </div>

</div>

<div class="card-glass">

    <!-- فلترة الفترة -->
    <form class="row g-3 mb-3 align-items-end" method="get">

        <div class="col-md-3">
            <label class="filter-label">من تاريخ تسجيل</label>
            <input type="date" name="from_date" class="form-control" value="<?= htmlspecialchars($from_date) ?>">
        </div>

        <div class="col-md-3">
            <label class="filter-label">إلى تاريخ تسجيل</label>
            <input type="date" name="to_date" class="form-control" value="<?= htmlspecialchars($to_date) ?>">
        </div>

        <div class="col-md-3">
            <button class="btn btn-primary w-100" type="submit">
                <i class="bi bi-funnel"></i> تطبيق الفلتر
            </button>
        </div>

        <div class="col-md-3 d-flex gap-2">
            <button type="button" id="exportPDF" class="btn btn-danger w-50">
                <i class="bi bi-filetype-pdf"></i> PDF
            </button>
            <button type="button" id="exportExcel" class="btn btn-success w-50">
                <i class="bi bi-file-earmark-excel"></i> Excel
            </button>
        </div>

    </form>

    <div class="table-responsive">
        <table id="dormTable" class="table table-bordered table-striped align-middle text-center">
            <thead>
                <tr>
                    <th>الاسم</th>
                    <th>الكلية</th>
                    <th>الهاتف</th>
                    <th>الجنس</th>
                    <th>مكان الولادة</th>
                    <th>العنوان</th>
                    <th>نقطة دالة</th>
                    <th>هاتف ولي الأمر</th>
                    <th class="actions-col">الإجراءات</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($students as $s): ?>
                <tr>
                    <td><?= htmlspecialchars($s["full_name"]) ?></td>
                    <td><?= htmlspecialchars($s["college_name"]) ?></td>
                    <td><?= htmlspecialchars($s["phone"]) ?></td>
                    <td><?= htmlspecialchars($s["gender"]) ?></td>
                    <td><?= htmlspecialchars($s["birth_place"]) ?></td>
                    <td><?= htmlspecialchars($s["address"]) ?></td>
                    <td><?= htmlspecialchars($s["nearest_point"]) ?></td>
                    <td><?= htmlspecialchars($s["guardian_phone1"]) ?></td>

                    <td class="actions-col">

                        <a href="student_view.php?id=<?= $s['id'] ?>" 
                           class="btn btn-primary btn-action" title="عرض">
                           <i class="bi bi-eye-fill"></i>
                        </a>

                        <a href="tel:<?= $s['phone'] ?>" 
                           class="btn btn-success btn-action" title="اتصال">
                           <i class="bi bi-telephone-fill"></i>
                        </a>

                        <a href="https://wa.me/964<?= substr($s['phone'],1) ?>" 
                           target="_blank" class="btn btn-success btn-action" style="background:#25D366;" title="واتساب">
                           <i class="bi bi-whatsapp"></i>
                        </a>

                        <a href="students_dorm_single_pdf.php?id=<?= $s['id'] ?>" 
                           target="_blank" class="btn btn-danger btn-action" title="PDF طالب">
                           <i class="bi bi-filetype-pdf"></i>
                        </a>

                        <a href="students_dorm_remove.php?id=<?= $s['id'] ?>" 
                           onclick="return confirm('إزالة الطالب من السكن؟');"
                           class="btn btn-warning btn-action" title="إزالة من السكن">
                           <i class="bi bi-x-circle-fill"></i>
                        </a>

                    </td>

                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

</div>

<!-- JS & DATATABLES -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
var table = new DataTable("#dormTable", {
    language: { url: "//cdn.datatables.net/plug-ins/1.13.4/i18n/ar.json" },
    pageLength: 25
});

// تصدير PDF
document.getElementById("exportPDF").onclick = function () {
    const f = document.querySelector("[name='from_date']").value;
    const t = document.querySelector("[name='to_date']").value;
    let url = "students_dorm_pdf.php?";
    if (f) url += "from_date=" + encodeURIComponent(f) + "&";
    if (t) url += "to_date="   + encodeURIComponent(t);
    window.open(url, "_blank");
};

// تصدير Excel
document.getElementById("exportExcel").onclick = function () {
    const f = document.querySelector("[name='from_date']").value;
    const t = document.querySelector("[name='to_date']").value;
    let url = "students_dorm_excel.php?";
    if (f) url += "from_date=" + encodeURIComponent(f) + "&";
    if (t) url += "to_date="   + encodeURIComponent(t);
    window.open(url, "_blank");
};
</script>

</div>

<?php require_once "includes/footer.php"; ?>