<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

guard_admin();

// استلام الفلترة
$from_date = $_GET['from_date'] ?? '';
$to_date   = $_GET['to_date']   ?? '';

$where = " WHERE dorm_request='نعم' ";
$params = [];

if (!empty($from_date)) {
    $where .= " AND DATE(created_at) >= :from_date ";
    $params[':from_date'] = $from_date;
}
if (!empty($to_date)) {
    $where .= " AND DATE(created_at) <= :to_date ";
    $params[':to_date'] = $to_date;
}

$sql = "
    SELECT full_name, college_name, phone, gender, birth_place, address, nearest_point, guardian_phone1
    FROM students
    $where
    ORDER BY id DESC
";

$stmt = $conn->prepare($sql);
$stmt->execute($params);

// اسم الملف
$filename = "dorm_students_" . date("Y-m-d") . ".csv";

// ارسال الهيدر لتحميل الملف
header("Content-Type: text/csv; charset=UTF-8");
header("Content-Disposition: attachment; filename=$filename");

// BOM UTF-8 لإصلاح العربية في Excel
echo "\xEF\xBB\xBF";

// فتح مخرجات CSV
$output = fopen("php://output", "w");

// عناوين الأعمدة
$header = [
    "الاسم",
    "الكلية",
    "الهاتف",
    "الجنس",
    "مكان الولادة",
    "العنوان",
    "أقرب نقطة دالة",
    "رقم ولي الأمر"
];
fputcsv($output, $header);

// جلب بيانات الطلاب
while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    fputcsv($output, $row);
}

fclose($output);
exit;
