<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

guard_admin();
require_once "../vendor/autoload.php";

// ==================== استلام الفلترة ====================
$from_date = $_GET['from_date'] ?? '';
$to_date   = $_GET['to_date']   ?? '';

$where = " WHERE dorm_request='نعم' ";
$params = [];

if ($from_date) {
    $where .= " AND DATE(created_at) >= :from_date ";
    $params[':from_date'] = $from_date;
}
if ($to_date) {
    $where .= " AND DATE(created_at) <= :to_date ";
    $params[':to_date'] = $to_date;
}

$sql = "
    SELECT full_name, college_name, phone, gender, birth_place, address, nearest_point, guardian_phone1
    FROM students
    $where
    ORDER BY id DESC
";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
$total_rows = count($rows);

// ==================== نص الفترة ====================
$period = "جميع الفترات";
if ($from_date && $to_date) {
    $period = "من $from_date إلى $to_date";
} elseif ($from_date) {
    $period = "ابتداءً من $from_date";
} elseif ($to_date) {
    $period = "حتى $to_date";
}

// ==================== تهيئة MPDF ====================
$tempDir = __DIR__ . '/../tmp';
if (!file_exists($tempDir)) mkdir($tempDir, 0777, true);

$mpdf = new \Mpdf\Mpdf([
    "mode" => "utf-8",
    "format" => "A4-L",
    "orientation" => "L",
    "tempDir" => $tempDir,
    "margin_left" => 5,
    "margin_right" => 5,
    "margin_top" => 40,
    "margin_bottom" => 14,
    "margin_header" => 6,
    "margin_footer" => 8,
    "default_font" => "dejavusans",
]);

$mpdf->SetWatermarkText("جامعة النبراس", 0.06);
$mpdf->showWatermarkText = true;

// ==================== HEADER — الشعار وسط ====================
$logo = "../assets/img/logo.png";

$headerHtml = '
<div style="text-align:center;">
    <img src="'.$logo.'" style="width:75px; margin-bottom:3px;">
</div>

<div style="text-align:center; font-size:18px; font-weight:bold;">
    قائمة الطلاب الراغبين بالسكن الداخلي
</div>

<div style="text-align:center; font-size:13px; margin-top:3px;">
جامعة النبراس – شعبة التسجيل
</div>

<div style="text-align:center; font-size:12px; margin-top:3px;">
فترة التقرير: '.$period.'
</div>
';

$mpdf->SetHTMLHeader($headerHtml);

// ==================== FOOTER ====================
$mpdf->SetHTMLFooter('
<table width="100%" style="border-top:1px solid #999; font-size:11px;" dir="rtl">
<tr>
    <td align="right">شعبة التسجيل – جامعة النبراس</td>
    <td align="left">صفحة {PAGENO} من {nb}</td>
</tr>
</table>
');

// ==================== جدول PDF بتصميم ثابت وألوان ظاهرة ====================
$html = '
<table width="100%" border="1" cellpadding="5" cellspacing="0" 
       style="border-collapse:collapse; font-size:12px;" dir="rtl">

<thead>
<tr style="background-color:#111827; color:#ffffff; font-weight:bold;">
    <td width="5%">م</td>
    <td width="17%">الاسم الكامل</td>
    <td width="14%">الكلية</td>
    <td width="12%">الهاتف</td>
    <td width="8%">الجنس</td>
    <td width="14%">مكان الولادة</td>
    <td width="16%">العنوان</td>
    <td width="14%">نقطة دالة</td>
    <td width="12%">هاتف ولي الأمر</td>
</tr>
</thead>

<tbody>
';

if (!$rows) {
    $html .= '<tr><td colspan="9" align="center">لا يوجد طلاب ضمن الفترة المحددة</td></tr>';
} else {
    $i = 0;
    foreach ($rows as $r) {

        // تظليل الصفوف بالتبادل (أبيض / رمادي فاتح جداً)
        $bg = ($i % 2 == 0) ? '#ffffff' : '#f3f4f6';

        $html .= '
        <tr style="background:'.$bg.';">
            <td>'.($i+1).'</td>
            <td>'.htmlspecialchars($r["full_name"]).'</td>
            <td>'.htmlspecialchars($r["college_name"]).'</td>
            <td>'.htmlspecialchars($r["phone"]).'</td>
            <td>'.htmlspecialchars($r["gender"]).'</td>
            <td>'.htmlspecialchars($r["birth_place"]).'</td>
            <td>'.htmlspecialchars($r["address"]).'</td>
            <td>'.htmlspecialchars($r["nearest_point"]).'</td>
            <td>'.htmlspecialchars($r["guardian_phone1"]).'</td>
        </tr>';

        $i++;
    }
}

$html .= "</tbody></table>";

// ==================== سطر أسفل الصفحة: التاريخ + عدد الطلاب ====================
$printedAt = date("Y-m-d H:i");

$html .= '
<br>
<table width="100%" style="font-size:11px;" dir="rtl">
<tr>
    <td align="right">
        إجمالي الطلاب في هذا التقرير: '.$total_rows.' طالب/ة
    </td>
    <td align="left">
        تاريخ الطباعة: '.$printedAt.'
    </td>
</tr>
</table>
';

// ==================== إخراج PDF ====================
$mpdf->WriteHTML($html);
$mpdf->Output("dorm_students.pdf", "I");
