<?php
session_start();

// حماية الدخول
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}
require_once "../config/security.php";
require_once "../config/db.php";

// CSRF
if (empty($_SESSION["csrf_token"])) {
    $_SESSION["csrf_token"] = bin2hex(random_bytes(32));
}

$type = $_GET["type"] ?? "admin";  
$table = $type === "finance" ? "finance_users" : "admins";

$msg = "";

// =======================
// معالجة الإضافة
// =======================
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"]) && $_POST["action"] === "add") {

    if ($_POST["csrf_token"] !== $_SESSION["csrf_token"]) {
        die("CSRF BLOCKED");
    }

    $name     = trim($_POST["name"]);
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);
    $role     = $_POST["role"] ?? null;

    if ($name === "" || $username === "" || $password === "") {
        $msg = "❌ يرجى إدخال جميع الحقول";
    } else {

        // فحص تكرار المستخدم
        $check = $conn->prepare("SELECT COUNT(*) FROM $table WHERE username = ?");
        $check->execute([$username]);

        if ($check->fetchColumn() > 0) {
            $msg = "⚠️ اسم المستخدم موجود مسبقاً";
        } else {

            $hash = password_hash($password, PASSWORD_BCRYPT);

            if ($type === "admin") {
                $insert = $conn->prepare("
                    INSERT INTO admins (name, username, password, role)
                    VALUES (?, ?, ?, ?)
                ");
                $insert->execute([$name, $username, $hash, $role]);
            } else {
                $insert = $conn->prepare("
                    INSERT INTO finance_users (name, username, password)
                    VALUES (?, ?, ?)
                ");
                $insert->execute([$name, $username, $hash]);
            }

            header("Location: users.php?type=$type&added=1");
            exit;
        }
    }
}

// =======================
// حذف المستخدم
// =======================
if (isset($_GET["delete"])) {
    $id = intval($_GET["delete"]);
    $del = $conn->prepare("DELETE FROM $table WHERE id = ?");
    $del->execute([$id]);
    header("Location: users.php?type=$type&deleted=1");
    exit;
}

// =======================
// جلب المستخدمين
// =======================
$data = $conn->query("SELECT * FROM $table ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة المستخدمين</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: linear-gradient(135deg, #0a0a0a, #1a1a1a);
    font-family: 'SF Pro Display', 'Tajawal', sans-serif;
    color: #fff;
}

/* ======= APPLE CARD ======= */
.apple-card {
    background: rgba(255,255,255,0.08);
    backdrop-filter: saturate(180%) blur(20px);
    -webkit-backdrop-filter: blur(20px);
    padding: 25px;
    border-radius: 20px;
    border: 1px solid rgba(255,255,255,0.15);
    box-shadow: 0 10px 30px rgba(0,0,0,0.25);
}

/* ======= TOP BAR ======= */
.top-tabs a {
    padding: 10px 25px;
    border-radius: 12px;
    margin-left: 5px;
    text-decoration: none;
    font-weight: 600;
    transition: 0.2s;
    color: #d0d0d0;
}
.top-tabs a.active {
    background: rgba(255,255,255,0.15);
    color: #fff;
}

/* ======= TABLE ======= */
.table {
    color: white;
    border-radius: 12px;
    overflow: hidden;
}
.table thead {
    background: rgba(255,255,255,0.12);
}
.table tbody tr {
    transition: 0.2s;
}
.table tbody tr:hover {
    background: rgba(255,255,255,0.07);
}

/* ======= ADD BUTTON ======= */
.add-btn {
    position: fixed;
    bottom: 35px;
    left: 35px;
    background: #0a84ff;
    border-radius: 50%;
    width: 65px;
    height: 65px;
    color: white;
    font-size: 35px;
    border: none;
    display: flex;
    justify-content: center;
    align-items: center;
    box-shadow: 0 10px 25px rgba(0,125,255,0.4);
    transition: 0.2s;
}
.add-btn:hover {
    transform: scale(1.09);
}

/* ======= MODAL ======= */
.modal-content {
    background: rgba(255,255,255,0.09);
    backdrop-filter: blur(18px);
    border-radius: 20px;
    border: 1px solid rgba(255,255,255,0.2);
    color: white;
}
.form-control, .form-select {
    background: rgba(255,255,255,0.10);
    border: none;
    color: white;
    border-radius: 12px;
}
.form-control:focus, .form-select:focus {
    background: rgba(255,255,255,0.15);
    outline: none;
    box-shadow: 0 0 0 2px #0a84ff;
}

/* DELETE BUTTON */
.btn-danger {
    border-radius: 10px;
}

</style>

</head>
<body>

<div class="container mt-5">

    <div class="apple-card">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 style="font-weight:700;">👥 إدارة المستخدمين</h3>

            <div class="top-tabs">
                <a href="users.php?type=admin" class="<?= $type=='admin' ? 'active':'' ?>">المدراء</a>
                <a href="users.php?type=finance" class="<?= $type=='finance' ? 'active':'' ?>">الحسابات المالية</a>
            </div>
        </div>

        <?php if(isset($_GET["added"])): ?>
            <div class="alert alert-success">✔ تم إضافة المستخدم بنجاح</div>
        <?php endif; ?>

        <?php if(isset($_GET["deleted"])): ?>
            <div class="alert alert-danger">✔ تم حذف المستخدم</div>
        <?php endif; ?>

        <?php if(!empty($msg)): ?>
            <div class="alert alert-warning"><?= $msg ?></div>
        <?php endif; ?>

        <table class="table table-bordered text-center">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الاسم</th>
                    <th>اسم المستخدم</th>
                    <?php if ($type === "admin"): ?>
                        <th>الصلاحية</th>
                    <?php endif; ?>
                    <th>عمليات</th>
                </tr>
            </thead>

            <tbody>
                <?php foreach($data as $row): ?>
                    <tr>
                        <td><?= $row["id"] ?></td>
                        <td><?= htmlspecialchars($row["name"]) ?></td>
                        <td><?= htmlspecialchars($row["username"]) ?></td>
                        <?php if ($type === "admin") echo "<td>{$row['role']}</td>"; ?>

                        <td>
                            <a href="users.php?type=<?=$type?>&delete=<?= $row['id'] ?>"
                               onclick="return confirm('هل تريد الحذف؟')"
                               class="btn btn-danger btn-sm">حذف</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>

        </table>

    </div>
</div>

<!-- زر الإضافة العائم -->
<button class="add-btn" data-bs-toggle="modal" data-bs-target="#addModal">+</button>

<!-- ====================== -->
<!-- مودال الإضافة -->
<!-- ====================== -->
<div class="modal fade" id="addModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

        <form method="POST">
            <input type="hidden" name="action" value="add">
            <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

            <div class="modal-header">
                <h5 class="modal-title">➕ مستخدم جديد</h5>
            </div>

            <div class="modal-body">

                <label>الاسم</label>
                <input type="text" name="name" class="form-control" required>

                <label class="mt-2">اسم المستخدم</label>
                <input type="text" name="username" class="form-control" required>

                <label class="mt-2">كلمة المرور</label>
                <input type="password" name="password" class="form-control" required minlength="3">

                <?php if ($type === "admin"): ?>
                <label class="mt-2">الصلاحية</label>
                <select name="role" class="form-select">
                    <option value="admin">مدير عام</option>
                    <option value="registration">التسجيل</option>
                    <option value="accounts">الحسابات</option>
                    <option value="president">رئيس الجامعة</option>
                </select>
                <?php endif; ?>

            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                <button class="btn btn-primary">إضافة</button>
            </div>

        </form>

    </div>
  </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
