<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";
require_once "../core/PdfGenerator.php";

// حماية
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Invalid ID");
}

$student_id = intval($_GET['id']);

// 1) تحديث حالة الطالب
$conn->prepare("UPDATE students SET status='verified' WHERE id=?")
     ->execute([$student_id]);

// 2) توليد استمارة PDF (خلف الكواليس – بدون فتح)
PdfGenerator::generateStudentForm($student_id);

// 3) العودة إلى صفحة معلومات الطالب
header("Location: student_view.php?id=" . $student_id . "&msg=verified_ok");
exit;
