<?php
require_once __DIR__ . '/../vendor/autoload.php';

use Mpdf\Mpdf;
use Mpdf\Output\Destination;

function generatePDF($html, $output_path) {

    try {

        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => 'A4',
            'margin_top'    => 15,
            'margin_bottom' => 15,
            'margin_left'   => 12,
            'margin_right'  => 12,
            'default_font'  => 'dejavusans',
            'rtl'           => true,
            'autoLangToFont' => true,
            'tempDir' => __DIR__ . '/../uploads/temp' // مهم لمنع أخطاء الذاكرة
        ]);

        $mpdf->WriteHTML($html);

        // حفظ الملف
        $mpdf->Output($output_path, Destination::FILE);

        return true;

    } catch (Exception $e) {

        error_log("MPDF Error: " . $e->getMessage());

        return false;
    }
}
