<?php

/* ============================================================
   ⚠️ هذا هو الكود الأصلي — لم يتم تغييره إطلاقاً
============================================================ */
function sendWhatsAppMessage($phone, $message)
{
    $instance = "instance153433";
    $token    = "zuakd3jkp0v55yej";

    // تنظيف الرقم
    $phone = str_replace([" ", "+", "-"], "", $phone);

    // رقم عراق → تحويل إلى 964
    if (substr($phone, 0, 1) === "0") {
        $phone = "964" . substr($phone, 1);
    }

    $url = "https://api.ultramsg.com/$instance/messages/chat";

    $post = [
        "token" => $token,
        "to"    => $phone,
        "body"  => $message
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $res = curl_exec($ch);
    curl_close($ch);

    return $res;
}

/* ============================================================
   ⭐ الإضافات الجديدة (بدون لمس الكود الأصلي)
============================================================ */

/*
------------------------------------------
📌 1) رسالة جاهزة: إشعار متأخر بالدفع
------------------------------------------
*/
function sendLatePaymentTemplate($student_name, $phone, $college, $study_type, $amount)
{
    $msg = "
📌 *تنبيه مالي – جامعة النبراس*
────────────────────
👤 الطالب: *$student_name*
🏫 القسم: *$college*
🎓 الدراسة: *$study_type*
💰 المبلغ المتأخر: *" . number_format($amount) . " د.ع*
────────────────────
نرجو الحضور لشعبة الحسابات لإتمام عملية التسديد.
🕓 الدوام: 8 صباحاً – 2 ظهراً

⚠️ تجاهل هذا الإشعار قد يؤدي لإيقاف تسجيلكم.

مع التحية.
";

    return sendWhatsAppMessage($phone, $msg);
}


/*
------------------------------------------
📌 2) رسالة جاهزة: إشعار تسجيل دفعة
   تستخدم في add_payment_save.php
------------------------------------------
*/
function sendPaymentTemplate($phone, $student_name, $amount, $receipt_number, $payment_type)
{
    $msg = "
🏛️ *جامعة النبراس – قسم الحسابات*

✔ *تم تسجيل دفعة جديدة*

👤 الطالب: *$student_name*
💵 المبلغ: *" . number_format($amount) . " د.ع*
🧾 رقم الوصل: *$receipt_number*
💳 نوع الدفع: *$payment_type*
📅 التاريخ: " . date("Y-m-d H:i") . "

شكراً لكم.
";

    return sendWhatsAppMessage($phone, $msg);
}


/*
------------------------------------------
📌 3) رسالة جاهزة: إشعار تعديل مرحلة الطالب
   تستخدم في update_level.php
------------------------------------------
*/
function sendLevelUpdateTemplate($phone, $student_name, $new_level, $fee)
{
    $msg = "
📢 *تم تحديث المرحلة الدراسية*

👤 الطالب: *$student_name*
📘 المرحلة الجديدة: *$new_level*
💰 القسط الجديد: *" . number_format($fee) . " د.ع*

تم فتح حساب جديد لهذه السنة.
";

    return sendWhatsAppMessage($phone, $msg);
}


/*
------------------------------------------
📌 4) إرسال جماعي — كل طالب رسالة منفصلة
------------------------------------------
*/
function sendBulkLateMessages($students)
{
    $sent = [];

    foreach ($students as $s) {

        $sent[] = [
            "name" => $s['full_name'],
            "phone" => $s['phone'],
            "status" => sendLatePaymentTemplate(
                $s['full_name'],
                $s['phone'],
                $s['college_name'],
                $s['study_type'],
                $s['remaining']
            )
        ];
    }

    return $sent;
}