<?php
// core/Auth.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/AdminController.php';

class Auth {

    public static function login($username, $password) {
        session_start();
        $admin = AdminController::getByUsername($username);
        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_role'] = $admin['role'];
            return true;
        }
        return false;
    }

    public static function check() {
        session_start();
        return isset($_SESSION['admin_id']);
    }

    public static function requireRole($roles = []) {
        session_start();
        if (!isset($_SESSION['admin_id'])) {
            header("Location: login.php");
            exit;
        }
        if (!empty($roles) && !in_array($_SESSION['admin_role'], $roles)) {
            die("ليس لديك صلاحية للوصول إلى هذه الصفحة");
        }
    }

    public static function logout() {
        session_start();
        session_destroy();
        header("Location: login.php");
        exit;
    }
}
