<?php
// core/FormBuilder.php

require_once __DIR__ . '/../config/db.php';

class FormBuilder {

    public static function getFields() {
        global $conn;
        $stmt = $conn->prepare("SELECT * FROM fields ORDER BY order_number ASC");
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public static function renderField($field, $value = null) {
        $name   = htmlspecialchars($field['field_name']);
        $label  = htmlspecialchars($field['field_label']);
        $type   = $field['field_type'];
        $req    = $field['is_required'] ? 'required' : '';
        $options = $field['options'] ? json_decode($field['options'], true) : [];

        echo '<div class="mb-3">';
        echo "<label class='form-label fw-bold'>{$label}</label>";

        switch ($type) {
            case 'text':
                echo "<input type='text' name='{$name}' value='".htmlspecialchars($value)."' class='form-control' {$req}>";
                break;

            case 'number':
                echo "<input type='number' name='{$name}' value='".htmlspecialchars($value)."' class='form-control' {$req}>";
                break;

            case 'date':
                echo "<input type='date' name='{$name}' value='".htmlspecialchars($value)."' class='form-control' {$req}>";
                break;

            case 'time':
                echo "<input type='time' name='{$name}' value='".htmlspecialchars($value)."' class='form-control' {$req}>";
                break;

            case 'textarea':
                echo "<textarea name='{$name}' class='form-control' {$req}>".htmlspecialchars($value)."</textarea>";
                break;

            case 'file':
                echo "<input type='file' name='{$name}' class='form-control' {$req}>";
                break;

            case 'select':
                echo "<select name='{$name}' class='form-select' {$req}>";
                foreach ($options as $opt) {
                    $sel = ($value == $opt) ? "selected" : "";
                    echo "<option value='".htmlspecialchars($opt)."' {$sel}>".htmlspecialchars($opt)."</option>";
                }
                echo "</select>";
                break;

            case 'radio':
                foreach ($options as $opt) {
                    $checked = ($value == $opt) ? "checked" : "";
                    echo "<div class='form-check'>";
                    echo "<input class='form-check-input' type='radio' name='{$name}' value='".htmlspecialchars($opt)."' {$checked} {$req}>";
                    echo "<label class='form-check-label'>".htmlspecialchars($opt)."</label>";
                    echo "</div>";
                }
                break;

            case 'checkbox':
                $values = is_array($value) ? $value : explode(',', (string)$value);
                foreach ($options as $opt) {
                    $checked = in_array($opt, $values) ? "checked" : "";
                    echo "<div class='form-check'>";
                    echo "<input class='form-check-input' type='checkbox' name='{$name}[]' value='".htmlspecialchars($opt)."' {$checked}>";
                    echo "<label class='form-check-label'>".htmlspecialchars($opt)."</label>";
                    echo "</div>";
                }
                break;

            case 'hidden':
                echo "<input type='hidden' name='{$name}' value='".htmlspecialchars($value)."'>";
                break;

            default:
                echo "<input type='text' name='{$name}' value='".htmlspecialchars($value)."' class='form-control' {$req}>";
                break;
        }

        echo '</div>';
    }

    public static function renderForm($values = []) {
        $fields = self::getFields();
        foreach ($fields as $field) {
            $name = $field['field_name'];
            $val  = isset($values[$name]) ? $values[$name] : null;
            self::renderField($field, $val);
        }
    }
}
