<?php
/**
 * PDFController – B2Pro Ultra Edition
 * دعم كامل للغة العربية + RTL + شعار الجامعة + CSS + حماية
 */

# ===========================================
# تحميل TCPDF (Composer أولاً)
# ===========================================
$autoload = __DIR__ . '/../vendor/autoload.php';
if (file_exists($autoload)) {
    require_once $autoload;
}

# ===========================================
# تحميل نسخة tcpdf المحلية
# ===========================================
if (!class_exists('TCPDF')) {
    $local = __DIR__ . '/../tcpdf/tcpdf.php';

    if (file_exists($local)) {
        require_once $local;
    } else {
        die("<b>❌ TCPDF غير مثبت</b><br>
        قم بتثبيته عبر Composer:<br>
        <code>composer require tecnickcom/tcpdf</code><br>
        أو ضع نسخة tcpdf/ داخل المشروع.");
    }
}

class PDFController
{
    /**
     * إنشاء PDF احترافي مع دعم RTL والشعار
     */
    public static function generate($title, $html, $filePath)
    {
        $pdf = self::setupPDF($title);

        // إضافة الشعار أعلى الصفحة
        self::addUniversityHeader($pdf);

        // إضافة صفحة
        $pdf->AddPage();

        // تفعيل RTL
        $pdf->setRTL(true);

        // تشغيل HTML
        $pdf->writeHTML($html, true, false, true, false, '');

        // إنشاء المجلد إذا لم يكن موجودًا
        $path = dirname($filePath);
        if (!is_dir($path)) {
            mkdir($path, 0777, true);
        }

        // حفظ الملف
        $pdf->Output($filePath, 'F');

        return $filePath;
    }

    /**
     * إخراج مباشر للمتصفح (Inline)
     */
    public static function outputInline($title, $html)
    {
        $pdf = self::setupPDF($title);

        self::addUniversityHeader($pdf);

        $pdf->AddPage();
        $pdf->setRTL(true);
        $pdf->writeHTML($html, true, false, true, false, '');
        $pdf->Output($title . ".pdf", 'I');
    }


    # =============================================
    #   إعدادات أساسية للـ PDF
    # =============================================
    private static function setupPDF($title)
    {
        $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);

        $pdf->SetCreator('Nebres University System');
        $pdf->SetAuthor('Nebres University');
        $pdf->SetTitle($title);

        // اتجاه القراءة
        $pdf->setRTL(true);

        // الهوامش
        $pdf->SetMargins(10, 35, 10, true);
        $pdf->SetHeaderMargin(5);
        $pdf->SetFooterMargin(10);

        // فوتر
        $pdf->setPrintFooter(true);

        // دعم الخط العربي
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 12, '', true);

        return $pdf;
    }


    # =============================================
    #   إضافة رأس صفحة (شعار + نص)
    # =============================================
    private static function addUniversityHeader($pdf)
    {
        $logoPath = __DIR__ . '/../assets/logo.png'; // ضع الشعار هنا

        $html = "<div style='text-align:center; font-size:14px;'>
                    <br>
                    <b>جامعة النبراس</b><br>
                    نظام الحسابات والمستحقات المالية<br><br>
                 </div>";

        $pdf->SetHeaderData(
            file_exists($logoPath) ? $logoPath : '',
            20, // حجم الشعار
            '',
            $html
        );
    }
}