<?php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../vendor/autoload.php';

use TCPDF;

class PdfGenerator {

    public static function generateStudentForm($student_id) {
        global $conn;

        // جلب بيانات الطالب
        $stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
        $stmt->execute([$student_id]);
        $s = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$s) return false;

        // مسارات الصور
        $logo      = realpath(__DIR__ . '/../assets/img/logo.png');
        $watermark = realpath(__DIR__ . '/../assets/img/watermark.png');

        // إنشاء صفحة A4
        $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        $pdf->SetMargins(8, 8, 8);
        $pdf->AddPage();

        $pdf->setRTL(true);
        $pdf->SetFont('dejavusans', '', 12);

        // ================================
        // 1) الإطار الخارجي
        // ================================
        $pdf->Rect(5, 5, 200, 287, 'D');

        // ================================
        // 2) الختم — watermark
        // ================================
        if ($watermark && file_exists($watermark)) {
            $pdf->SetAlpha(0.12);
            $pdf->Image(
                $watermark,
                20, 60,   // X , Y
                170, 170, // العرض والارتفاع
                'PNG'
            );
            $pdf->SetAlpha(1);
        }

        // ================================
        // 3) الهيدر العلوي
        // ================================
        $headerHTML = '
        <table width="100%" cellpadding="0">
            <tr>
                <td align="right" width="33%" style="font-size:14px; line-height:1.5;">
                    جمهورية العراق<br>
                    وزارة التعليم العالي والبحث العلمي<br>
                    دائرة التعليم الجامعي الأهلي<br>
                    جامعة النبراس الأهلية<br>
                    قسم التسجيل
                </td>

                <td align="center" width="33%">
                    <img src="'.$logo.'" width="120">
                </td>

                <td align="left" width="33%" style="font-size:14px; line-height:1.5;">
                    Republic of Iraq<br>
                    Ministry of Higher Education<br>
                    Private Education Directorate<br>
                    Al-Nibras University<br>
                    Registration Dept.
                </td>
            </tr>
        </table>

        <br><br>

        <h3 align="center"><u>استمارة المعلومات</u></h3>
        ';

        $pdf->writeHTML($headerHTML, true, false, true, false, '');

        // ================================
        // 4) جدول البيانات (مطابق للملف)
        // ================================
        $tableHTML = '
        <table border="1" cellpadding="8" cellspacing="0" width="100%" style="font-size:15px;">

            <tr>
                <td width="25%">اسم الطالب</td>
                <td>'.htmlspecialchars($s["full_name"]).'</td>
            </tr>

            <tr>
                <td>الرقم الامتحاني</td>
                <td>'.htmlspecialchars($s["exam_number"]).'</td>
            </tr>

            <tr>
                <td>سنة التخرج</td>
                <td>'.htmlspecialchars($s["graduation_year"]).'</td>
                <td>الدور</td>
                <td>'.htmlspecialchars($s["exam_round"]).'</td>
            </tr>

            <tr>
                <td>الفرع</td>
                <td>'.htmlspecialchars($s["branch"]).'</td>
                <td>رقم الكود</td>
                <td></td>
            </tr>

            <tr>
                <td>الكلية / القسم</td>
                <td colspan="3">'.htmlspecialchars($s["college_name"]).'</td>
            </tr>

        </table>

        <br><br><br>

        <div align="right" style="font-size:16px; font-weight:bold">
            ختم وتوقيع موظف التسجيل
        </div>
        ';

        $pdf->writeHTML($tableHTML, true, false, true, false, '');

        // ================================
        // 5) حفظ الملف
        // ================================
        $folder = __DIR__ . '/../uploads/pdfs/';
        if (!is_dir($folder)) mkdir($folder, 0777, true);

        $file = "student_form_" . $student_id . ".pdf";
        $output = $folder . $file;

        $pdf->Output($output, 'F');

        return $output;
    }
}

