<?php
// core/TimelineController.php – B2Pro Ultra Edition

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/Logger.php';

class TimelineController
{

    /**
     * إضافة حدث للتايملاين (يعتمد على Logger الجديد)
     */
    public static function addEvent($admin_id, $student_id, $action, $details = "")
    {
        // نستخدم Logger مباشرة — لأنه يسجل جميع التفاصيل والـ IP والمتصفح
        Logger::log($admin_id, $student_id, $action, $details);
        return true;
    }


    /**
     * جلب سجل التايملاين لطالب واحد
     */
    public static function getTimeline($student_id)
    {
        global $conn;

        $stmt = $conn->prepare("
            SELECT 
                logs.id,
                logs.action,
                logs.details,
                logs.created_at,
                logs.ip_address,
                logs.user_agent,
                admins.name AS admin_name

            FROM logs
            LEFT JOIN admins ON admins.id = logs.admin_id
            WHERE logs.student_id = ?
            ORDER BY logs.created_at DESC
        ");

        $stmt->execute([$student_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }


    /**
     * تحويل الأكشن إلى نص مفهوم للواجهة
     */
    public static function actionText($action)
    {
        $map = [

            "CREATE_ACCOUNT"      => "تم إنشاء حساب مالي للطالب",
            "UPDATE_ACCOUNT"      => "تم تعديل بيانات الحساب المالي",
            "ADD_PAYMENT"         => "تم إضافة دفعة مالية",
            "DELETE_PAYMENT"      => "تم حذف دفعة مالية",

            "UPDATE_DUE_DATE"     => "تم تعديل تاريخ الاستحقاق",
            "UPDATE_INSTALLMENTS" => "تم تحديث جدول الأقساط",

            "NOTIFICATION_SENT"   => "تم إرسال إشعار واتساب",
            "NOTIFICATION_FAILED" => "فشل إرسال الإشعار",

            "CREATE_STUDENT"      => "تم إضافة الطالب",
            "UPDATE_STUDENT"      => "تم تحديث بيانات الطالب",
            "DELETE_STUDENT"      => "تم حذف طالب",

            "LOGIN"               => "تسجيل دخول",
            "LOGOUT"              => "تسجيل خروج",
        ];

        return $map[$action] ?? $action;
    }


    /**
     * تجهيز HTML كامل لعرض التايملاين في صفحة view.php
     */
    public static function renderHTML($events)
    {
        if (empty($events)) {
            return "<div class='alert alert-info text-center'>لا توجد أحداث مسجّلة.</div>";
        }

        $html = '<ul class="timeline" style="direction:rtl;">';

        foreach ($events as $e) {

            $action     = self::actionText($e['action']);
            $details    = nl2br(htmlspecialchars($e['details']));
            $admin_name = $e['admin_name'] ?? "غير معروف";
            $date       = $e['created_at'];

            $ip   = $e['ip_address'] ?? '—';
            $agent = $e['user_agent'] ?? '—';

            $html .= '
                <li>
                    <div class="timeline-badge bg-primary"></div>

                    <div class="timeline-panel glass-panel">

                        <h6><b>' . $action . '</b></h6>

                        <p style="margin-bottom:8px;">' . $details . '</p>

                        <small class="text-info d-block">
                            👤 ' . $admin_name . '
                            — 🕒 ' . $date . '
                            <br>
                            🌐 IP: ' . $ip . '
                        </small>
                    </div>
                </li>
            ';
        }

        $html .= '</ul>';
        return $html;
    }

}