<?php
require_once __DIR__ . '/../config/backup_settings.php';

echo "Cleaning old backups...\n";

$folder = $backup_folder;

if (!is_dir($folder)) {
    die("Backup folder not found!\n");
}

$files = scandir($folder);
$now = time();

foreach ($files as $file) {
    if ($file == "." || $file == "..") continue;

    $file_path = $folder . $file;

    if (is_file($file_path)) {
        // عمر النسخة
        $file_age_days = ( ($now - filemtime($file_path)) / 86400 );

        if ($file_age_days > $backup_retention_days) {
            unlink($file_path);
            echo "Deleted: $file\n";
        }
    }
}

echo "Cleanup finished.\n";
