<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../core/NotificationController.php';

echo "Checking due payments...\n";

// جلب الطلاب الذين اقترب موعد الدفع لهم خلال 3 أيام
$stmt = $conn->prepare("
    SELECT students.id, students.full_name, students.phone, accounts.total_fee, accounts.paid, accounts.remaining, accounts.due_date
    FROM accounts
    JOIN students ON accounts.student_id = students.id
    WHERE accounts.due_date IS NOT NULL
    AND accounts.remaining > 0
    AND DATEDIFF(accounts.due_date, CURDATE()) <= 3
");
$stmt->execute();

$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

$notification_template = "جامعة النبراس الأهلية\nعزيزي الطالب {name}\nلديك مبلغ متبقي {remaining} دينار.\nتاريخ الاستحقاق: {due_date}\nيرجى مراجعة الحسابات.";

foreach ($students as $s) {
    echo "Sending notification to: {$s['full_name']} - {$s['phone']}\n";
    NotificationController::sendToStudent($s, $notification_template);
}

echo "Notifications sent.\n";
