<?php

require 'vendor/autoload.php';

use PhpOffice\PhpWord\TemplateProcessor;
use PhpOffice\PhpWord\IOFactory;

require_once "config/db.php";

function generateStudentDoc($student_id) {
    global $conn;
$template = new TemplateProcessor(__DIR__ . '/../templates/student_form.docx');

    // جلب بيانات الطالب
    $stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
    $stmt->execute([$student_id]);
    $s = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$s) return false;

    // تحميل القالب
    $templatePath = __DIR__ . "/templates/student_form.docx";
    $template = new TemplateProcessor($templatePath);

    // تعبئة القيم
    $template->setValue('student_name', $s['full_name']);
    $template->setValue('exam_number', $s['exam_number']);
    $template->setValue('graduation_year', $s['graduation_year']);
    $template->setValue('exam_round', $s['exam_round']);
    $template->setValue('branch', $s['branch']);
    $template->setValue('college_name', $s['college_name']);
    $template->setValue('code_number', ''); // يملأ يدوياً لاحقاً

    // حفظ DOCX جديد
    $output_docx = __DIR__ . "/uploads/word/student_{$student_id}.docx";
    $template->saveAs($output_docx);

    // تحويل إلى PDF
    $phpWord = IOFactory::load($output_docx);
    $output_pdf = __DIR__ . "/uploads/pdfs/student_{$student_id}.pdf";

    $pdfWriter = IOFactory::createWriter($phpWord, 'PDF');
    $pdfWriter->save($output_pdf);

    return $output_pdf;
}
