<?php

require_once __DIR__ . "/vendor/autoload.php";

use PhpOffice\PhpWord\TemplateProcessor;
use Dompdf\Dompdf;

/**
 * توليد ملف Word من القالب
 */
function generateStudentWord($data) {

    // مسار ملف الوورد الأصلي
    $templatePath = __DIR__ . "/templates/student_form.docx";

    if (!file_exists($templatePath)) {
        die("❌ ملف القالب غير موجود!");
    }

    // تحميل القالب
    $template = new TemplateProcessor($templatePath);

    // استبدال الحقول
    $template->setValue("student_name", $data['full_name']);
    $template->setValue("exam_number", $data['exam_number']);
    $template->setValue("graduation_year", $data['graduation_year']);
    $template->setValue("exam_round", $data['exam_round']);
    $template->setValue("branch", $data['branch']);
    $template->setValue("code_number", ""); // يبقى فارغ
    $template->setValue("college_name", $data['college_name']);

    // اسم الملف النهائي DOCX
    $outputDocx = __DIR__ . "/outputs/" . preg_replace('/\s+/', '_', $data['full_name']) . ".docx";

    if (!is_dir(__DIR__ . "/outputs/")) {
        mkdir(__DIR__ . "/outputs/", 0777, true);
    }

    // حفظ الملف الجديد
    $template->saveAs($outputDocx);

    return $outputDocx;
}

/**
 * تحويل DOCX إلى PDF بنفس التصميم
 */
function convertWordToPDF($docxPath, $pdfPath) {

    // تحويل DOCX → HTML
    $phpWord = \PhpOffice\PhpWord\IOFactory::load($docxPath);
    $htmlWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'HTML');

    // ملف HTML مؤقت
    $tempHtml = tempnam(sys_get_temp_dir(), 'html');
    $htmlWriter->save($tempHtml);

    // إنشاء PDF
    $dompdf = new Dompdf();
    $dompdf->loadHtml(file_get_contents($tempHtml));
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // حفظ PDF
    file_put_contents($pdfPath, $dompdf->output());
}

/**
 * تشغيل النظام الكامل
 */
function generateStudentPDF($studentData)
{
    // 1) توليد DOCX
    $docx = generateStudentWord($studentData);

    // 2) توليد PDF
    $pdfPath = __DIR__ . "/outputs/" . preg_replace('/\s+/', '_', $studentData['full_name']) . ".pdf";
    convertWordToPDF($docx, $pdfPath);

    return [
        "docx" => $docx,
        "pdf"  => $pdfPath
    ];
}


// ============================
//  مثال تشغيل حقيقي
// ============================

/*
$student = [
    "full_name"        => "عبدالعزيز سامي",
    "exam_number"      => "123456",
    "graduation_year"  => "2023",
    "exam_round"       => "الدور الأول",
    "branch"           => "تطبيقي",
    "college_name"     => "تقنيات الحاسوب"
];

$result = generateStudentPDF($student);

echo "DOCX: " . $result['docx'] . "<br>";
echo "PDF: "  . $result['pdf'];
*/
?>
