<?php
require_once 'vendor/autoload.php';
require_once 'config/db.php';

use PhpOffice\PhpWord\TemplateProcessor;
use PhpOffice\PhpWord\IOFactory;

// استقبال ID الطالب
$student_id = intval($_GET['id']);

// جلب بيانات الطالب
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$student_id]);
$s = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$s) die("الطالب غير موجود");
$template = new TemplateProcessor(__DIR__ . '/../templates/student_form.docx');

// تحميل قالب الوورد


// تعبئة الحقول داخل الوورد
$template->setValue('full_name',        $s['full_name']);
$template->setValue('exam_number',      $s['exam_number']);
$template->setValue('graduation_year',  $s['graduation_year']);
$template->setValue('exam_round',       $s['exam_round']);
$template->setValue('branch',           $s['branch']);
$template->setValue('college_name',     $s['college_name']);

// رقم الكود يبقى فارغ ويدخله الموظف بعد الطباعة
$template->setValue('code_number', "");

// حفظ نسخة Word قبل التحويل
$docx_output = "uploads/pdfs/form_" . $student_id . ".docx";
$template->saveAs($docx_output);

// تحويل Word → PDF
$phpWord = IOFactory::load($docx_output);
$pdf_output = "uploads/pdfs/form_" . $student_id . ".pdf";

$xmlWriter = IOFactory::createWriter($phpWord, 'PDF');
$xmlWriter->save($pdf_output);

// إظهار رابط التحميل
echo "<h3>تم إنتاج الملف بنجاح</h3>";
echo "<a href='$pdf_output' target='_blank'>📄 تحميل PDF</a><br>";
echo "<a href='$docx_output' target='_blank'>📝 تحميل DOCX</a>";

?>
