<?php
require_once "config/bootstrap.php";
require_once "config/db.php";

// جلب الكليات + الجامعات
$colleges = $conn->query("SELECT * FROM colleges ORDER BY college_name ASC")->fetchAll(PDO::FETCH_ASSOC);

// جلب قنوات التقديم
$channels = $conn->query("SELECT * FROM channels ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

// القسط الافتراضي لأول كلية
$default_fee = isset($colleges[0]) ? $colleges[0]['fee'] : 0;

// بناء قائمة الجامعات (بدون تكرار)
$universities = [];
foreach ($colleges as $co) {
    if (!empty($co['university_name']) && !in_array($co['university_name'], $universities)) {
        $universities[] = $co['university_name'];
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>استمارة التقديم - جامعة النبراس الأهلية</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
    body {
       background: linear-gradient(90deg, #1c1c32ff, #3a393aff);
        background-size: 300% 300%;
        animation: gradientBG 12s ease infinite;
        color: #fffdfdff;
        font-family: "Tajawal", sans-serif;
    }
    @keyframes gradientBG {
        0% {background-position: 0% 50%;}
        50% {background-position: 100% 50%;}
        100% {background-position: 0% 50%;}
    }

    .glass-box {
        background: rgba(73, 71, 71, 0.4);
        backdrop-filter: blur(16px);
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 8px 40px rgba(237, 227, 227, 0.2);
        border: 1px solid rgba(255, 255, 255, 1);
    }

    .section-title {
        font-size: 22px;
        font-weight: bold;
        text-align: center;
        margin: 30px 0 20px;
        padding: 10px;
        border-radius: 10px;
        background: rgba(255,255,255,0.12);
    }

    label { font-weight: bold; margin-top: 10px; }

    .btn-submit {
        background: linear-gradient(90deg, #4f46e5, #7c3aed);
        border: none;
        padding: 12px;
        font-size: 18px;
        color: white;
        border-radius: 10px;
        transition: 0.3s;
        width: 100%;
    }
    .btn-submit:hover { transform: scale(1.04); opacity: 0.9; }

    #feeBox {
        margin-top: 15px;
        padding: 12px;
        background: rgba(255,255,255,0.10);
        border-radius: 12px;
        font-size: 18px;
        display: none;
    }
</style>
</head>

<body>

<!-- NAVBAR -->
<nav class="navbar navbar-dark">
    <div class="container">
        <a class="navbar-brand">
            <img src="assets/images/logo.png" width="59">
            جامعة النبراس الأهلية – استمارة التقديم
        </a>
    </div>
</nav>

<div class="container my-4">
    <div class="glass-box">

        <h2 class="text-center mb-4">استمارة التقديم الإلكتروني</h2>

        <form action="submit.php" method="POST" enctype="multipart/form-data">

            <!-- معلومات الطالب -->
            <div class="section-title">معلومات الطالب</div>

            <label>الاسم الرباعي واللقب</label>
            <input type="text" name="full_name" class="form-control" required>

            <label>رقم البطاقة الوطنية أو الجواز</label>
            <input type="text" name="national_or_passport" class="form-control" required>

            <label>رقم الهاتف</label>
            <input type="text" name="phone" class="form-control" required>

            <label>البريد الإلكتروني</label>
            <input type="email" name="email" class="form-control">

            <label>اسم الأم الثلاثي</label>
            <input type="text" name="mother_name" class="form-control" required>

            <label>محل الولادة</label>
            <input type="text" name="birth_place" class="form-control">

            <label>محل السكن</label>
            <input type="text" name="address" class="form-control">

            <label>أقرب نقطة دالة</label>
            <input type="text" name="nearest_point" class="form-control">

            <label>الجنس</label>
            <select name="gender" class="form-select">
                <option value="ذكر">ذكر</option>
                <option value="انثى">انثى</option>
            </select>

            <label>رقم هاتف ولي الأمر 1</label>
            <input type="text" name="guardian_phone1" class="form-control">

            <label>رقم هاتف ولي الأمر 2</label>
            <input type="text" name="guardian_phone2" class="form-control">

            <label>صورة الطالب (خلفية بيضاء)</label>
            <input type="file" name="student_photo" class="form-control">


            <!-- معلومات المدرسة -->
            <div class="section-title">معلومات المدرسة / المعهد</div>

            <label>اسم المدرسة</label>
            <input type="text" name="school_name" class="form-control">

            <label>الفرع</label>
            <input type="text" name="branch" class="form-control">

            <label>سنة التخرج</label>
            <input type="number" name="graduation_year" class="form-control">

            <label>الدور</label>
            <select name="exam_round" class="form-select">
                <option value="الدور الاول">الدور الأول</option>
                <option value="الدور الثاني">الدور الثاني</option>
                <option value="الدور الثالث">الدور الثالث</option>
            </select>

            <label>محاولات</label>
            <select name="attempts" class="form-select">
                <option value="لا">لا</option>
                <option value="نعم">نعم</option>
            </select>

            <label>سنوات الرسوب</label>
            <input type="text" name="fail_years" class="form-control">

            <label>الرقم الامتحاني</label>
            <input type="text" name="exam_number" class="form-control" required>

            <label>الرقم السري</label>
            <input type="text" name="secret_number" class="form-control">

            <label>عدد الدروس</label>
            <input type="number" id="subjects" name="subjects_count" class="form-control" required>

            <label>المجموع</label>
            <input type="number" id="total" name="total_score" class="form-control" required>

            <label>المعدل</label>
            <input type="text" id="average" name="average" class="form-control" readonly>


            <!-- حساب المعدل -->
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script>
                $("#subjects, #total").on("keyup change", function(){
                    $.post("verify_calc.php", {
                        subjects: $("#subjects").val(),
                        total: $("#total").val()
                    }, function(data){
                        $("#average").val(data);
                    });
                });
            </script>


            <!-- قناة التقديم -->
            <div class="section-title">قناة التقديم</div>

            <select name="admission_channel" class="form-select" required>
                <?php foreach($channels as $ch): ?>
                    <option value="<?= htmlspecialchars($ch['channel_name']) ?>">
                        <?= htmlspecialchars($ch['channel_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>


            <!-- اختيار الجامعة / الكلية -->
            <div class="section-title">اختيار الجامعة / الكلية</div>

            <label>اسم الجامعة</label>
            <select name="university_name" id="universitySelect" class="form-select" required>
                <?php foreach($universities as $u): ?>
                    <option value="<?= htmlspecialchars($u) ?>"><?= htmlspecialchars($u) ?></option>
                <?php endforeach; ?>
            </select>

            <label>الكلية / القسم</label>
            <select name="college_name" id="collegeSelect" class="form-select" required>
                <?php foreach($colleges as $co): ?>
                    <option value="<?= htmlspecialchars($co['college_name']) ?>"
                            data-fee="<?= $co['fee'] ?>">
                        <?= htmlspecialchars($co['college_name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <!-- مربع عرض القسط -->
            <div id="feeBox">القسط السنوي: <span id="feeText"></span> دينار</div>

            <!-- حقل مخفي لإرسال القسط -->
            <input type="hidden" name="college_fee" id="hiddenFee" value="<?= $default_fee ?>">


            <label>نوع الدراسة</label>
            <select name="study_type" class="form-select">
                <option value="صباحي">صباحي</option>
                <option value="مسائي">مسائي</option>
            </select>


            <!-- بيانات إضافية -->
            <div class="section-title">بيانات إضافية (اختياري)</div>

            <label>اسم مستخدم التطبيق</label>
            <input type="text" name="app_username" class="form-control">

            <label>الرمز السري للتطبيق</label>
            <input type="password" name="app_password" class="form-control">

            <label>السكن الداخلي</label>
            <select name="dorm_request" class="form-select">
                <option value="كلا">كلا</option>
                <option value="نعم">نعم</option>
            </select>

            <div class="text-center mt-4">
                <button class="btn-submit">إرسال الاستمارة</button>
            </div>

        </form>
    </div>
</div>

<script>
$(document).ready(function() {
    function updateFee() {
        let fee = $("#collegeSelect option:selected").data("fee");
        $("#feeText").text(fee.toLocaleString());
        $("#hiddenFee").val(fee);
        $("#feeBox").show();
    }

    updateFee();
    $("#collegeSelect").on("change", updateFee);
});
</script>

</body>
</html>