<?php
// president/dashboard.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/app.php';

// مفتاح الدخول الخاص بالرئيس
$PRESIDENT_KEY = "a"; // غيّره لقيمة سرية قوية

if (!isset($_GET['key']) || $_GET['key'] !== $PRESIDENT_KEY) {
    http_response_code(403);
    echo "غير مصرح لك بالدخول.";
    exit;
}

// جلب الإحصائيات
// إجمالي الطلاب
$total_students = $conn->query("SELECT COUNT(*) FROM students")->fetchColumn();

// حسب الحالات
$pending_students   = $conn->query("SELECT COUNT(*) FROM students WHERE status='pending'")->fetchColumn();
$verified_students  = $conn->query("SELECT COUNT(*) FROM students WHERE status='verified'")->fetchColumn();
$accepted_students  = $conn->query("SELECT COUNT(*) FROM students WHERE status='accepted'")->fetchColumn();

// ملخص مالي
$finance = $conn->query("
    SELECT 
        COUNT(accounts.id) AS accounts_count,
        COALESCE(SUM(accounts.total_fee),0) AS total_fee,
        COALESCE(SUM(accounts.paid),0) AS total_paid,
        COALESCE(SUM(accounts.remaining),0) AS total_remaining
    FROM accounts
")->fetch(PDO::FETCH_ASSOC);

// قنوات التقديم
$channels_stats = $conn->query("
    SELECT admission_channel, COUNT(*) AS cnt
    FROM students
    GROUP BY admission_channel
    ORDER BY cnt DESC
")->fetchAll(PDO::FETCH_ASSOC);

// أكثر الأقسام اختياراً
$top_departments = $conn->query("
    SELECT college_name, study_type, COUNT(*) AS cnt
    FROM students
    GROUP BY college_name, study_type
    ORDER BY cnt DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة رئيس الجامعة - إحصائيات عامة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    margin: 0;
    min-height: 100vh;
    background: radial-gradient(circle at top, #1e293b, #020617);
    color: #e5e7eb;
    font-family: "Tajawal", sans-serif;
}
.header-bar {
    background: linear-gradient(90deg, #0f172a, #1d4ed8);
    padding: 15px 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.4);
}
.header-bar img {
    width: 55px;
    height: 55px;
    border-radius: 999px;
    background: #fff;
}
.header-bar .title {
    font-size: 22px;
    font-weight: 700;
}
.header-bar .subtitle {
    font-size: 14px;
    opacity: 0.8;
}
.page-container {
    max-width: 1200px;
    margin: 25px auto 40px;
    padding: 0 15px 40px;
}
.glass-card {
    background: rgba(15,23,42,0.86);
    border-radius: 18px;
    padding: 20px 20px 15px;
    border: 1px solid rgba(148,163,184,0.3);
    box-shadow: 0 20px 60px rgba(15,23,42,0.7);
    margin-bottom: 25px;
}
.section-title {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 8px;
}
.section-title span.icon {
    width: 24px;
    height: 24px;
    border-radius: 999px;
    background: rgba(59,130,246,0.2);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;
}
.stat-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit,minmax(200px,1fr));
    gap: 15px;
}
.stat-box {
    border-radius: 16px;
    padding: 15px;
    background: radial-gradient(circle at top, rgba(59,130,246,0.35), rgba(15,23,42,0.95));
    border: 1px solid rgba(148,163,184,0.3);
}
.stat-label {
    font-size: 13px;
    opacity: 0.8;
}
.stat-value {
    font-size: 24px;
    font-weight: 700;
}
.stat-chip {
    display: inline-block;
    font-size: 11px;
    padding: 2px 8px;
    border-radius: 999px;
    background: rgba(15,23,42,0.85);
    border: 1px solid rgba(148,163,184,0.4);
    margin-top: 5px;
}
.table {
    color: #e5e7eb;
    font-size: 13px;
}
.table thead {
    background: rgba(15,23,42,0.9);
}
.table tbody tr:nth-child(even) {
    background: rgba(15,23,42,0.7);
}
.table tbody tr:nth-child(odd) {
    background: rgba(15,23,42,0.5);
}
.badge-channel {
    background: rgba(59,130,246,0.2);
    color: #032957ff;
    border-radius: 999px;
    padding: 4px 9px;
    font-size: 12px;
}
</style>
</head>
<body>

<div class="header-bar">
    <img src="../assets/images/logo.png" alt="شعار الجامعة">
    <div>
        <div class="title">جامعة النبراس الأهلية</div>
        <div class="subtitle">لوحة رئيس الجامعة – عرض إحصائي فقط (قراءة)</div>
    </div>
</div>

<div class="page-container">

    <!-- الكروت الرئيسية -->
    <div class="glass-card">
        <div class="section-title">
            <span class="icon">📊</span>
            نظرة عامة على التقديم
        </div>
        <div class="stat-grid">
            <div class="stat-box">
                <div class="stat-label">إجمالي عدد الطلاب المتقدمين</div>
                <div class="stat-value"><?= number_format($total_students) ?></div>
                <div class="stat-chip">جميع الحالات</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">طلبات قيد التدقيق</div>
                <div class="stat-value"><?= number_format($pending_students) ?></div>
                <div class="stat-chip">status: pending</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">طلبات مدققة</div>
                <div class="stat-value"><?= number_format($verified_students) ?></div>
                <div class="stat-chip">status: verified</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">طلبات مقبولة</div>
                <div class="stat-value"><?= number_format($accepted_students) ?></div>
                <div class="stat-chip">status: accepted</div>
            </div>
        </div>
    </div>

    <!-- ملخص مالي عام -->
    <div class="glass-card">
        <div class="section-title">
            <span class="icon">💰</span>
            الملخص المالي العام
        </div>
        <div class="stat-grid">
            <div class="stat-box">
                <div class="stat-label">عدد ملفات الحسابات المفتوحة</div>
                <div class="stat-value"><?= number_format($finance['accounts_count']) ?></div>
                <div class="stat-chip">حسابات طلاب لديهم أقساط</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">إجمالي الأقساط الكلية</div>
                <div class="stat-value"><?= number_format($finance['total_fee']) ?></div>
                <div class="stat-chip">دينار عراقي</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">إجمالي المبالغ المدفوعة</div>
                <div class="stat-value"><?= number_format($finance['total_paid']) ?></div>
                <div class="stat-chip">مجموع ما تم تسديده</div>
            </div>
            <div class="stat-box">
                <div class="stat-label">إجمالي المبالغ المتبقية</div>
                <div class="stat-value"><?= number_format($finance['total_remaining']) ?></div>
                <div class="stat-chip">أقساط ما زالت مستحقة</div>
            </div>
        </div>
    </div>

    <!-- قنوات التقديم -->
    <div class="glass-card">
        <div class="section-title">
            <span class="icon">🎯</span>
            توزيع الطلاب حسب قناة التقديم
        </div>
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead>
                    <tr>
                        <th>قناة التقديم</th>
                        <th class="text-center">عدد الطلاب</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($channels_stats) == 0): ?>
                        <tr><td colspan="2" class="text-center">لا توجد بيانات حالياً.</td></tr>
                    <?php else: ?>
                        <?php foreach ($channels_stats as $row): ?>
                            <tr>
                                <td>
                                    <span class="badge-channel">
                                        <?= htmlspecialchars($row['admission_channel'] ?: 'غير محدد') ?>
                                    </span>
                                </td>
                                <td class="text-center"><?= number_format($row['cnt']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- أكثر الأقسام اختياراً -->
    <div class="glass-card">
        <div class="section-title">
            <span class="icon">🏛️</span>
            أكثر الأقسام / الكليات اختياراً
        </div>
        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead>
                    <tr>
                        <th>الكلية / القسم</th>
                        <th>نوع الدراسة</th>
                        <th class="text-center">عدد الطلاب</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($top_departments) == 0): ?>
                        <tr><td colspan="3" class="text-center">لا توجد بيانات حالياً.</td></tr>
                    <?php else: ?>
                        <?php foreach ($top_departments as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['college_name'] ?: 'غير محدد') ?></td>
                                <td><?= htmlspecialchars($row['study_type'] ?: '-') ?></td>
                                <td class="text-center"><?= number_format($row['cnt']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

</body>
</html>
