-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost
-- Generation Time: Dec 01, 2025 at 03:49 AM
-- Server version: 10.4.28-MariaDB
-- PHP Version: 8.2.4

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `nebres_university`
--

-- --------------------------------------------------------

--
-- Table structure for table `accounts`
--

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `total_fee` int(11) NOT NULL DEFAULT 0,
  `discount` int(11) NOT NULL DEFAULT 0,
  `paid` int(11) NOT NULL DEFAULT 0,
  `remaining` int(11) NOT NULL DEFAULT 0,
  `level` enum('المرحلة الأولى','المرحلة الثانية','المرحلة الثالثة','المرحلة الرابعة','المرحلة الخامسة') NOT NULL DEFAULT 'المرحلة الأولى',
  `payment_plan` enum('دفعة واحدة','دفعتين','3 دفعات','4 دفعات','5 دفعات','6 دفعات') NOT NULL DEFAULT 'دفعة واحدة',
  `installments` int(11) NOT NULL DEFAULT 1,
  `amount_per_installment` int(11) NOT NULL DEFAULT 0,
  `year` int(11) NOT NULL DEFAULT year(curdate()),
  `installment1` int(11) DEFAULT 0,
  `installment2` int(11) DEFAULT 0,
  `installment3` int(11) DEFAULT 0,
  `installment4` int(11) DEFAULT 0,
  `installment5` int(11) DEFAULT 0,
  `installment6` int(11) DEFAULT 0,
  `due_date` date DEFAULT NULL,
  `last_update` datetime DEFAULT current_timestamp(),
  `status` enum('normal','warning','late','critical','frozen') DEFAULT 'normal',
  `last_overdue` int(11) DEFAULT 0,
  `collection_status` enum('none','in_progress','promise_to_pay','no_response','refused','legal') DEFAULT 'none'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `account_installments`
--

CREATE TABLE `account_installments` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `paid_amount` int(11) DEFAULT 0,
  `paid_date` datetime DEFAULT NULL,
  `status` enum('pending','partial','paid','late') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `account_years`
--

CREATE TABLE `account_years` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `level` enum('المرحلة الأولى','المرحلة الثانية','المرحلة الثالثة','المرحلة الرابعة','المرحلة الخامسة') NOT NULL,
  `total_fee` int(11) NOT NULL DEFAULT 0,
  `paid` int(11) NOT NULL DEFAULT 0,
  `remaining` int(11) NOT NULL DEFAULT 0,
  `payment_plan` varchar(50) DEFAULT 'دفعة واحدة',
  `year_label` varchar(20) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `admins`
--

CREATE TABLE `admins` (
  `id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `username` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','registration','accounts','president') NOT NULL DEFAULT 'registration',
  `phone` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `admins`
--

INSERT INTO `admins` (`id`, `name`, `username`, `password`, `role`, `phone`, `created_at`) VALUES
(1, 'مدير التسجيل', 'admin', '$2y$10$IUefco7XTOiWfZ6DcGrRZO9Q.dcPGjrPb3d5hBvShjXluTes5nHXq', 'registration', NULL, '2025-11-27 14:30:57');

-- --------------------------------------------------------

--
-- Table structure for table `ai_fraud_logs`
--

CREATE TABLE `ai_fraud_logs` (
  `id` int(11) NOT NULL,
  `payment_id` int(11) DEFAULT NULL,
  `student_id` int(11) NOT NULL,
  `risk_score` int(11) NOT NULL,
  `risk_level` enum('LOW','MEDIUM','HIGH','CRITICAL') NOT NULL,
  `reason` text DEFAULT NULL,
  `detected_at` datetime DEFAULT current_timestamp(),
  `status` enum('clean','under_review','blocked') DEFAULT 'under_review'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `appearance_settings`
--

CREATE TABLE `appearance_settings` (
  `id` int(11) NOT NULL,
  `key_name` varchar(190) DEFAULT NULL,
  `key_value` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `appearance_settings`
--

INSERT INTO `appearance_settings` (`id`, `key_name`, `key_value`) VALUES
(1, 'mode', 'dark'),
(2, 'primary_color', '#6366f1'),
(3, 'secondary_color', '#3b82f6'),
(4, 'bg_color', '#0f172a'),
(5, 'bg_opacity', '0.12'),
(6, 'glass_blur', '12'),
(7, 'font_family', 'Noto Kufi Arabic');

-- --------------------------------------------------------

--
-- Table structure for table `audit_log`
--

CREATE TABLE `audit_log` (
  `id` int(11) NOT NULL,
  `admin_name` varchar(150) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `backup_logs`
--

CREATE TABLE `backup_logs` (
  `id` int(11) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `file_size` varchar(100) DEFAULT NULL,
  `drive_url` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `backup_settings`
--

CREATE TABLE `backup_settings` (
  `id` int(11) NOT NULL,
  `key_name` varchar(190) DEFAULT NULL,
  `key_value` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `builder_settings`
--

CREATE TABLE `builder_settings` (
  `id` int(11) NOT NULL,
  `key_name` varchar(190) DEFAULT NULL,
  `key_value` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `channels`
--

CREATE TABLE `channels` (
  `id` int(11) NOT NULL,
  `channel_name` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `channels`
--

INSERT INTO `channels` (`id`, `channel_name`, `created_at`) VALUES
(3, 'الشهداء', '2025-11-30 03:14:22');

-- --------------------------------------------------------

--
-- Table structure for table `collection_agents`
--

CREATE TABLE `collection_agents` (
  `id` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `username` varchar(150) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `collection_followup`
--

CREATE TABLE `collection_followup` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `agent_id` int(11) DEFAULT NULL,
  `contact_type` enum('phone','whatsapp','visit','email') DEFAULT 'phone',
  `status` enum('pending','responded','promise','no_answer','refused') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `next_follow` date DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `colleges`
--

CREATE TABLE `colleges` (
  `id` int(11) NOT NULL,
  `university_name` varchar(255) DEFAULT NULL,
  `college_name` varchar(255) NOT NULL,
  `study_type` enum('صباحي','مسائي') DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `fee` int(11) NOT NULL DEFAULT 0,
  `years` int(11) NOT NULL DEFAULT 4
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `colleges`
--

INSERT INTO `colleges` (`id`, `university_name`, `college_name`, `study_type`, `created_at`, `fee`, `years`) VALUES
(4, 'جامعة النبراس', 'هندسة الحاسبات', 'صباحي', '2025-11-30 03:12:38', 1900000, 4);

-- --------------------------------------------------------

--
-- Table structure for table `documents`
--

CREATE TABLE `documents` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `file_type` varchar(100) DEFAULT NULL,
  `uploaded_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `fields`
--

CREATE TABLE `fields` (
  `id` int(11) NOT NULL,
  `field_name` varchar(200) NOT NULL,
  `field_label` varchar(255) NOT NULL,
  `field_type` enum('text','number','date','time','textarea','file','radio','checkbox','select','calculated','hidden') NOT NULL,
  `is_required` tinyint(1) DEFAULT 0,
  `show_in_pdf` tinyint(1) DEFAULT 1,
  `show_in_dashboard` tinyint(1) DEFAULT 1,
  `order_number` int(11) DEFAULT 0,
  `options` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `section_name` varchar(150) DEFAULT 'personal'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `finance_users`
--

CREATE TABLE `finance_users` (
  `id` int(11) NOT NULL,
  `name` varchar(200) NOT NULL,
  `username` varchar(150) NOT NULL,
  `password` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `finance_users`
--

INSERT INTO `finance_users` (`id`, `name`, `username`, `password`, `created_at`) VALUES
(1, 'مدير الحسابات', 'az', '$2y$10$vRl.OoiorlpYkxxB1zcqFOxzZBuiVXVNVbLpoaucewdqmIUys5526', '2025-11-29 22:03:38');

-- --------------------------------------------------------

--
-- Table structure for table `installments`
--

CREATE TABLE `installments` (
  `id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `due_date` date NOT NULL,
  `status` enum('pending','paid','late') DEFAULT 'pending',
  `paid_at` datetime DEFAULT NULL,
  `reminder_sent` tinyint(1) DEFAULT 0,
  `late_notice_sent` tinyint(1) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `installments_master`
--

CREATE TABLE `installments_master` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `paid_amount` int(11) DEFAULT 0,
  `status` enum('pending','partial','paid','late') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `installment_due_dates`
--

CREATE TABLE `installment_due_dates` (
  `id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date DEFAULT NULL,
  `status` enum('paid','pending','late') DEFAULT 'pending',
  `updated_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `installment_plan`
--

CREATE TABLE `installment_plan` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `year_level` varchar(100) NOT NULL,
  `total_fee` bigint(20) NOT NULL,
  `installments_count` int(11) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `installment_schedule`
--

CREATE TABLE `installment_schedule` (
  `id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `installment_number` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `due_date` date NOT NULL,
  `paid_amount` int(11) DEFAULT 0,
  `paid_date` datetime DEFAULT NULL,
  `status` enum('pending','partial','paid','late') DEFAULT 'pending',
  `notes` text DEFAULT NULL,
  `penalty_amount` int(11) NOT NULL DEFAULT 0,
  `overdue_days` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `logs`
--

CREATE TABLE `logs` (
  `id` int(11) NOT NULL,
  `admin_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `notifications`
--

CREATE TABLE `notifications` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `message` text DEFAULT NULL,
  `status` enum('sent','failed') DEFAULT 'sent',
  `sent_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `overdue_alerts`
--

CREATE TABLE `overdue_alerts` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `days_late` int(11) NOT NULL,
  `alert_level` enum('warning','late','critical') NOT NULL,
  `message` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `receipt_number` varchar(100) DEFAULT NULL,
  `receipt_image` varchar(255) DEFAULT NULL,
  `payment_type` enum('نقدي','حوالة','إلكتروني','منحة') DEFAULT 'نقدي',
  `notes` text DEFAULT NULL,
  `paid_at` datetime DEFAULT current_timestamp(),
  `account_year_id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `reminder_jobs`
--

CREATE TABLE `reminder_jobs` (
  `id` int(11) NOT NULL,
  `installment_id` int(11) NOT NULL,
  `reminder_type` enum('72h','24h','12h','1h','late') NOT NULL,
  `sent` tinyint(1) DEFAULT 0,
  `sent_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int(11) NOT NULL,
  `setting_key` varchar(150) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `setting_key`, `setting_value`, `updated_at`) VALUES
(1, 'university_name', 'جامعة النبراس', '2025-11-28 01:14:06');

-- --------------------------------------------------------

--
-- Table structure for table `students`
--

CREATE TABLE `students` (
  `id` int(11) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `national_or_passport` varchar(200) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `mother_name` varchar(200) DEFAULT NULL,
  `birth_place` varchar(200) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `nearest_point` varchar(200) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `guardian_phone1` varchar(50) DEFAULT NULL,
  `guardian_phone2` varchar(50) DEFAULT NULL,
  `student_photo` varchar(255) DEFAULT NULL,
  `pdf_file` varchar(255) DEFAULT NULL,
  `school_name` varchar(255) DEFAULT NULL,
  `branch` varchar(150) DEFAULT NULL,
  `graduation_year` varchar(10) DEFAULT NULL,
  `exam_round` enum('الدور الاول','الدور الثاني','الدور الثالث') DEFAULT NULL,
  `attempts` enum('نعم','لا') DEFAULT NULL,
  `fail_years` varchar(150) DEFAULT NULL,
  `exam_number` varchar(100) NOT NULL,
  `secret_number` varchar(100) DEFAULT NULL,
  `subjects_count` int(11) DEFAULT NULL,
  `total_score` int(11) DEFAULT NULL,
  `average` float DEFAULT NULL,
  `admission_channel` varchar(255) DEFAULT NULL,
  `university_name` varchar(255) DEFAULT NULL,
  `college_name` varchar(255) DEFAULT NULL,
  `study_type` enum('صباحي','مسائي') DEFAULT NULL,
  `app_username` varchar(150) DEFAULT NULL,
  `app_password` varchar(150) DEFAULT NULL,
  `dorm_request` enum('نعم','كلا') DEFAULT NULL,
  `status` enum('pending','verified','accepted') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `college_fee` int(11) NOT NULL DEFAULT 0,
  `wallet_balance` bigint(20) DEFAULT 0,
  `credit_score` int(11) DEFAULT 600,
  `risk_level` enum('منخفض','متوسط','عالي','خطير') DEFAULT 'متوسط'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `student_pdf`
--

CREATE TABLE `student_pdf` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `pdf_path` varchar(255) NOT NULL,
  `pdf_name` varchar(255) NOT NULL,
  `file_size` varchar(50) DEFAULT NULL,
  `uploaded_by` varchar(150) DEFAULT NULL,
  `uploaded_ip` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `student_support`
--

CREATE TABLE `student_support` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `reply` text DEFAULT NULL,
  `status` enum('pending','answered') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `timeline_logs`
--

CREATE TABLE `timeline_logs` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `event_type` enum('payment_add','payment_edit','installment_paid','installment_partial','installment_late','installment_created','discount_applied','plan_changed','level_changed','account_created','account_reset') NOT NULL,
  `amount` int(11) DEFAULT NULL,
  `installment_number` int(11) DEFAULT NULL,
  `old_value` varchar(255) DEFAULT NULL,
  `new_value` varchar(255) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `wallet_transactions`
--

CREATE TABLE `wallet_transactions` (
  `id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `type` enum('إيداع','سحب','خصم قسط','إضافة قسط') NOT NULL,
  `amount` bigint(20) NOT NULL,
  `old_balance` bigint(20) NOT NULL,
  `new_balance` bigint(20) NOT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `whatsapp_templates`
--

CREATE TABLE `whatsapp_templates` (
  `id` int(11) NOT NULL,
  `template_key` varchar(190) DEFAULT NULL,
  `template_text` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `accounts`
--
ALTER TABLE `accounts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `account_installments`
--
ALTER TABLE `account_installments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `account_id` (`account_id`);

--
-- Indexes for table `account_years`
--
ALTER TABLE `account_years`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_std_acc` (`student_id`);

--
-- Indexes for table `admins`
--
ALTER TABLE `admins`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- Indexes for table `ai_fraud_logs`
--
ALTER TABLE `ai_fraud_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `payment_id` (`payment_id`);

--
-- Indexes for table `appearance_settings`
--
ALTER TABLE `appearance_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `key_name` (`key_name`);

--
-- Indexes for table `audit_log`
--
ALTER TABLE `audit_log`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `backup_logs`
--
ALTER TABLE `backup_logs`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `backup_settings`
--
ALTER TABLE `backup_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `key_name` (`key_name`);

--
-- Indexes for table `builder_settings`
--
ALTER TABLE `builder_settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `key_name` (`key_name`);

--
-- Indexes for table `channels`
--
ALTER TABLE `channels`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `collection_agents`
--
ALTER TABLE `collection_agents`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `collection_followup`
--
ALTER TABLE `collection_followup`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `agent_id` (`agent_id`);

--
-- Indexes for table `colleges`
--
ALTER TABLE `colleges`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `documents`
--
ALTER TABLE `documents`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `fields`
--
ALTER TABLE `fields`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `finance_users`
--
ALTER TABLE `finance_users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- Indexes for table `installments`
--
ALTER TABLE `installments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `installments_master`
--
ALTER TABLE `installments_master`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `installment_due_dates`
--
ALTER TABLE `installment_due_dates`
  ADD PRIMARY KEY (`id`),
  ADD KEY `account_id` (`account_id`);

--
-- Indexes for table `installment_plan`
--
ALTER TABLE `installment_plan`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `installment_schedule`
--
ALTER TABLE `installment_schedule`
  ADD PRIMARY KEY (`id`),
  ADD KEY `account_id` (`account_id`);

--
-- Indexes for table `logs`
--
ALTER TABLE `logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `log_student_fk` (`student_id`);

--
-- Indexes for table `notifications`
--
ALTER TABLE `notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `overdue_alerts`
--
ALTER TABLE `overdue_alerts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`),
  ADD KEY `pay_year_fk` (`account_year_id`);

--
-- Indexes for table `reminder_jobs`
--
ALTER TABLE `reminder_jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `installment_id` (`installment_id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`);

--
-- Indexes for table `students`
--
ALTER TABLE `students`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `student_pdf`
--
ALTER TABLE `student_pdf`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `student_support`
--
ALTER TABLE `student_support`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `timeline_logs`
--
ALTER TABLE `timeline_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `student_id` (`student_id`);

--
-- Indexes for table `whatsapp_templates`
--
ALTER TABLE `whatsapp_templates`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `template_key` (`template_key`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `accounts`
--
ALTER TABLE `accounts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=71;

--
-- AUTO_INCREMENT for table `account_installments`
--
ALTER TABLE `account_installments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `account_years`
--
ALTER TABLE `account_years`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `admins`
--
ALTER TABLE `admins`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT for table `ai_fraud_logs`
--
ALTER TABLE `ai_fraud_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `appearance_settings`
--
ALTER TABLE `appearance_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=29;

--
-- AUTO_INCREMENT for table `audit_log`
--
ALTER TABLE `audit_log`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `backup_logs`
--
ALTER TABLE `backup_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `backup_settings`
--
ALTER TABLE `backup_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `builder_settings`
--
ALTER TABLE `builder_settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `channels`
--
ALTER TABLE `channels`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `collection_agents`
--
ALTER TABLE `collection_agents`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `collection_followup`
--
ALTER TABLE `collection_followup`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `colleges`
--
ALTER TABLE `colleges`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `documents`
--
ALTER TABLE `documents`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `fields`
--
ALTER TABLE `fields`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `finance_users`
--
ALTER TABLE `finance_users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `installments`
--
ALTER TABLE `installments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `installments_master`
--
ALTER TABLE `installments_master`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `installment_due_dates`
--
ALTER TABLE `installment_due_dates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `installment_plan`
--
ALTER TABLE `installment_plan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `installment_schedule`
--
ALTER TABLE `installment_schedule`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT for table `logs`
--
ALTER TABLE `logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `notifications`
--
ALTER TABLE `notifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `overdue_alerts`
--
ALTER TABLE `overdue_alerts`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `reminder_jobs`
--
ALTER TABLE `reminder_jobs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `students`
--
ALTER TABLE `students`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=47;

--
-- AUTO_INCREMENT for table `student_pdf`
--
ALTER TABLE `student_pdf`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `student_support`
--
ALTER TABLE `student_support`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `timeline_logs`
--
ALTER TABLE `timeline_logs`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `whatsapp_templates`
--
ALTER TABLE `whatsapp_templates`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `accounts`
--
ALTER TABLE `accounts`
  ADD CONSTRAINT `acc_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `account_years`
--
ALTER TABLE `account_years`
  ADD CONSTRAINT `fk_std_acc` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ai_fraud_logs`
--
ALTER TABLE `ai_fraud_logs`
  ADD CONSTRAINT `ai_fraud_logs_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ai_fraud_logs_ibfk_2` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `collection_followup`
--
ALTER TABLE `collection_followup`
  ADD CONSTRAINT `collection_followup_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `collection_followup_ibfk_2` FOREIGN KEY (`agent_id`) REFERENCES `collection_agents` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `documents`
--
ALTER TABLE `documents`
  ADD CONSTRAINT `documents_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `installment_due_dates`
--
ALTER TABLE `installment_due_dates`
  ADD CONSTRAINT `installment_due_dates_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `installment_plan`
--
ALTER TABLE `installment_plan`
  ADD CONSTRAINT `installment_plan_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `installment_schedule`
--
ALTER TABLE `installment_schedule`
  ADD CONSTRAINT `installment_schedule_ibfk_1` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `logs`
--
ALTER TABLE `logs`
  ADD CONSTRAINT `log_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `notifications`
--
ALTER TABLE `notifications`
  ADD CONSTRAINT `notif_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `overdue_alerts`
--
ALTER TABLE `overdue_alerts`
  ADD CONSTRAINT `overdue_alerts_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `pay_student_fk` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `pay_year_fk` FOREIGN KEY (`account_year_id`) REFERENCES `account_years` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `reminder_jobs`
--
ALTER TABLE `reminder_jobs`
  ADD CONSTRAINT `reminder_jobs_ibfk_1` FOREIGN KEY (`installment_id`) REFERENCES `installment_due_dates` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `student_pdf`
--
ALTER TABLE `student_pdf`
  ADD CONSTRAINT `student_pdf_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `student_support`
--
ALTER TABLE `student_support`
  ADD CONSTRAINT `student_support_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `timeline_logs`
--
ALTER TABLE `timeline_logs`
  ADD CONSTRAINT `timeline_logs_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`);

--
-- Constraints for table `wallet_transactions`
--
ALTER TABLE `wallet_transactions`
  ADD CONSTRAINT `wallet_transactions_ibfk_1` FOREIGN KEY (`student_id`) REFERENCES `students` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
