<?php
session_start();

/* ------------------------------------------
   منع الرجوع بعد تسجيل الخروج + منع الكاش
------------------------------------------- */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");
header("Expires: 0");

/* ------------------------------------------
   فحص تسجيل الدخول
------------------------------------------- */
if (!isset($_SESSION["student_id"])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";

/* ------------------------------------------
   جلب بيانات الطالب
------------------------------------------- */
$student_id = $_SESSION["student_id"];
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$student_id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

/* ------------------------------------------
   الطالب غير مقبول
------------------------------------------- */
if ($student["status"] != "accepted") {
    require_once "application_status.php";
    exit;
}

$active = "dashboard";
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
<meta charset="UTF-8">
<title>لوحة الطالب</title>

<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>

/* ------------------------------- */
/*      الهوية البصرية — Light UI */
/* ------------------------------- */

body {
    margin: 0;
    padding: 0;
    background: #f7f8fa;
    font-family: "Tajawal", sans-serif;
    color: #1e293b;
}

/* غلاف يشبه شاشة موبايل */
.app-shell {
    min-height: 100vh;
    max-width: 480px;
    margin: 0 auto;
    background: #ffffff;
    box-shadow: 0 0 40px rgba(0,0,0,0.1);
    display: flex;
    flex-direction: column;
}

/* الهيدر */
.page-header {
    padding: 16px;
    background: linear-gradient(135deg, #3b82f6, #2563eb);
    border-radius: 0 0 18px 18px;
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    box-shadow: 0 4px 20px rgba(0,0,0,0.25);
}

.page-header .welcome {
    font-size: 16px;
    font-weight: 700;
}

.page-header .welcome span {
    display: block;
    font-size: 13px;
    font-weight: 400;
    opacity: 0.85;
}

.logout-btn {
    background: rgba(255,255,255,0.25);
    padding: 6px 13px;
    border-radius: 999px;
    color: white;
    font-size: 13px;
    font-weight: 600;
    text-decoration: none;
    backdrop-filter: blur(8px);
}

/* المحتوى */
.main-content {
    flex: 1;
    padding: 18px 15px 90px;
}

/* كارد Light */
.card-glass {
    background: #ffffff;
    border-radius: 14px;
    padding: 14px;
    border: 1px solid #e2e8f0;
    box-shadow: 0 3px 15px rgba(0,0,0,0.07);
    transition: 0.2s;
}

.card-glass:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 22px rgba(0,0,0,0.12);
}

/* حالة الطالب */
.status-box {
    text-align: center;
}

.small-note {
    text-align: center;
    color: #64748b;
    font-size: 13px;
}

/* شبكة الأيقونات */
.icon-box {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 14px;
    padding: 14px 10px;
    text-align: center;
    text-decoration: none;
    display: block;
    color: #1e293b;
    font-weight: 600;
    transition: 0.15s;
    box-shadow: 0 3px 15px rgba(0,0,0,0.06);
}

.icon-box:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 22px rgba(0,0,0,0.12);
}

.icon-box i {
    font-size: 26px;
    color: #2563eb;
    margin-bottom: 6px;
}

.section-title {
    font-size: 15px;
    font-weight: 700;
    margin-bottom: 8px;
    color: #334155;
}

</style>
</head>

<body>

<div class="app-shell">

    <!-- الهيدر -->
    <div class="page-header">
        <div class="welcome">
            لوحة الطالب
            <span>مرحباً، <?= htmlspecialchars($student["full_name"]) ?></span>
        </div>
        <a class="logout-btn" href="logout.php">
            <i class="bi bi-box-arrow-right"></i>
            خروج
        </a>
    </div>

    <div class="main-content">

        <!-- حالة الطالب -->
        <div class="status-box mb-3">
            <div class="card-glass">

            <?php if($student["status"] == "accepted"): ?>
                <span class="badge bg-success p-2 px-3">
                    <i class="bi bi-patch-check-fill"></i> تم قبولك – ألف مبروك!
                </span>
            <?php endif; ?>

            <div class="small-note mt-2">
                🎓 نتمنى لك بداية موفقة في دراستك داخل جامعة النبراس.
            </div>

            </div>
        </div>

        <!-- خدمات -->
        <div class="section-title">الخدمات</div>

        <div class="row g-3">

            <div class="col-6">
                <a href="profile.php" class="icon-box">
                    <i class="bi bi-person-lines-fill"></i>
                    بياناتي
                </a>
            </div>

            <div class="col-6">
                <a href="installments.php" class="icon-box">
                    <i class="bi bi-wallet2"></i>
                    الأقساط
                </a>
            </div>

            <div class="col-6">
                <a href="payments.php" class="icon-box">
                    <i class="bi bi-receipt"></i>
                    الدفعات
                </a>
            </div>

            <div class="col-6">
                <a href="pdf_view.php" class="icon-box">
                    <i class="bi bi-file-earmark-pdf"></i>
                    PDF
                </a>
            </div>

            <div class="col-6">
                <a href="college.php" class="icon-box">
                    <i class="bi bi-building"></i>
                    الكلية
                </a>
            </div>

            <!-- 🚍 باص الجامعة (بديل الدعم) -->
            <div class="col-6">
                <a href="bus.php" class="icon-box">
                    <i class="bi bi-bus-front-fill"></i>
                    باص الجامعة
                </a>
            </div>

        </div>

    </div>
</div>

<!-- منع الرجوع -->
<script>
if (window.history && window.history.pushState) {
    window.history.pushState(null, null, window.location.href);
    window.onpopstate = function () {
        window.history.pushState(null, null, window.location.href);
    };
}
</script>

</body>
</html>