<?php
if (!isset($_SESSION)) session_start();
require_once "../config/db.php";
require_once "../config/security.php";

if (!isset($_SESSION['student_id'])) {
    header("Location: ../login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة الطالب</title>

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>
:root{
    --bg:#0f172a;
    --glass:rgba(255,255,255,0.07);
    --glass-border:rgba(255,255,255,0.15);
    --text:#e2e8f0;
    --accent:#60a5fa;
}

body{
    background:var(--bg);
    color:var(--text);
    font-family:"Tajawal";
    margin:0;
    padding-bottom:90px; /* لتفادي تغطية البار السفلي */
}

/* صندوق زجاجي */
.card-glass{
    background:var(--glass);
    border:1px solid var(--glass-border);
    border-radius:16px;
    padding:18px;
    backdrop-filter:blur(10px);
}

/* الهيدر العلوي */
.page-header{
    padding:18px 20px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    background:linear-gradient(135deg,#3b82f6,#6366f1);
    border-bottom-left-radius:22px;
    border-bottom-right-radius:22px;
    box-shadow:0 5px 15px rgba(0,0,0,0.4);
}

.page-header .welcome{
    font-size:20px;
    font-weight:800;
}

/* زر خروج */
.logout-btn{
    background:#ef4444;
    color:white;
    padding:8px 14px;
    border-radius:10px;
    font-size:15px;
    text-decoration:none;
    display:flex;
    align-items:center;
    gap:5px;
}

/* ⬇️ شريط التنقل السفلي (Bottom Navigation) */
.nav-bottom{
    position:fixed;
    bottom:0;
    left:0;
    right:0;
    height:70px;
    background:rgba(15,23,42,0.95);
    backdrop-filter:blur(8px);
    display:flex;
    justify-content:space-around;
    align-items:center;
    border-top:1px solid rgba(255,255,255,0.1);
    z-index:1000;
}

.nav-bottom a{
    color:#94a3b8;
    text-decoration:none;
    text-align:center;
    font-size:12px;
    transition:0.3s;
}

.nav-bottom a.active{
    color:#60a5fa;
}

.nav-bottom i{
    font-size:25px;
    display:block;
}

/* Animation عند الحركة */
.nav-bottom a.animate{
    animation:pop .4s ease;
}

@keyframes pop{
    0%{ transform:scale(0.6); opacity:0.4; }
    100%{ transform:scale(1); opacity:1; }
}

</style>
</head>
<body>