<?php
session_start();
if(!isset($_SESSION["student_id"])) {
    header("Location: login.php"); exit;
}

require_once "../config/db.php";

$student_id = $_SESSION["student_id"];

// جلب الحساب المالي
$q1 = $conn->prepare("SELECT * FROM accounts WHERE student_id=? LIMIT 1");
$q1->execute([$student_id]);
$acc = $q1->fetch(PDO::FETCH_ASSOC);

$account_id = $acc ? $acc["id"] : null;

// جلب الأقساط والدفعات
if ($account_id) {
    $q2 = $conn->prepare("SELECT * FROM installment_schedule WHERE account_id=? ORDER BY installment_number ASC");
    $q2->execute([$account_id]);
    $installments = $q2->fetchAll(PDO::FETCH_ASSOC);

    $q3 = $conn->prepare("SELECT * FROM payments WHERE student_id=? ORDER BY paid_at DESC");
    $q3->execute([$student_id]);
    $payments = $q3->fetchAll(PDO::FETCH_ASSOC);
} else {
    $installments = [];
    $payments = [];
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
<meta charset="UTF-8">
<title>الأقساط المالية</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    background:#020617;
    font-family:"Tajawal";
    color:white;
    margin:0;
}

/* حاوية على شكل تطبيق موبايل */
.app-shell{
    min-height:100vh;
    max-width:480px;
    margin:0 auto;
    background:radial-gradient(circle at top,#0f172a,#020617);
    box-shadow:0 0 35px rgba(0,0,0,0.7);
}

/* الهيدر */
.navbar-custom {
    background:linear-gradient(135deg,#1e293b,#3b82f6);
    padding:14px 16px;
    border-radius:0 0 18px 18px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    box-shadow:0 4px 18px rgba(0,0,0,0.45);
}
.navbar-custom .title {
    font-size:16px;
    font-weight:800;
    color:#e5e7eb;
    display:flex;
    align-items:center;
    gap:6px;
}
.navbar-custom .title i{
    font-size:18px;
    color:#bfdbfe;
}

/* زر الرجوع الكبير */
.back-btn{
    width:40px;
    height:40px;
    border-radius:50%;
    background:rgba(15,23,42,0.95);
    border:1px solid rgba(148,163,184,0.9);
    display:flex;
    align-items:center;
    justify-content:center;
    color:#e5e7eb;
    font-size:24px;
    text-decoration:none;
    box-shadow:0 4px 15px rgba(0,0,0,0.6);
}

/* المحتوى */
.container-app{
    padding:18px 14px 60px;
}

/* كارت الملخص */
.summary-card {
    background:rgba(255,255,255,0.08);
    border:1px solid rgba(255,255,255,0.15);
    padding:18px;
    border-radius:18px;
    margin-top:18px;
    backdrop-filter:blur(6px);
}

/* شريط التقدم */
.progress {
    height:11px;
    border-radius:10px;
    background:rgba(15,23,42,0.9);
}
.progress-bar {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border-radius:10px;
}

/* Timeline */
.timeline {
    position:relative;
    margin-top:18px;
}
.timeline::before {
    content:"";
    position:absolute;
    width:3px;
    background:#1f2937;
    top:0; bottom:0;
    left:22px;
    border-radius:4px;
}
.timeline-item {
    position:relative;
    padding-left:58px;
    margin-bottom:18px;
}
.timeline-icon {
    position:absolute;
    width:40px;
    height:40px;
    border-radius:50%;
    left:2px;
    background:#020617;
    border:2px solid #3b82f6;
    display:flex;
    justify-content:center;
    align-items:center;
    font-size:18px;
}
.timeline-card {
    background:rgba(15,23,42,0.9);
    border:1px solid rgba(148,163,184,0.35);
    padding:12px 14px;
    border-radius:14px;
}

/* كارت الوصل */
.receipt-card {
    background:rgba(15,23,42,0.9);
    border-radius:14px;
    padding:12px 14px;
    border:1px solid rgba(148,163,184,0.35);
    margin-bottom:12px;
    font-size:13px;
}

/* صورة الوصل */
.receipt-img {
    width:100%;
    border-radius:12px;
}
</style>
</head>

<body>

<div class="app-shell">

    <!-- الهيدر -->
    <div class="navbar-custom">
        <span class="title">
            <i class="bi bi-wallet2"></i>
            الأقساط المالية
        </span>
        <a href="dashboard.php" class="back-btn">
            <i class="bi bi-arrow-right-circle-fill"></i>
        </a>
    </div>

    <div class="container-app">

        <?php if (!$account_id): ?>
            <div class="alert alert-info text-dark fw-bold mt-3">
                لم يتم إنشاء الحساب المالي بعد — سيتم تفعيله بعد قبولك.
            </div>
        <?php else: ?>

            <!-- ملخص -->
            <div class="summary-card">
                <h6 class="mb-2"><i class="bi bi-cash-coin"></i> الملخص المالي</h6>

                <div class="row mt-2 text-center" style="font-size:13px;">
                    <div class="col-4">
                        <div class="text-info">الكلي</div>
                        <div class="fw-bold"><?= number_format($acc["total_fee"]) ?> د.ع</div>
                    </div>

                    <div class="col-4">
                        <div class="text-success">المدفوع</div>
                        <div class="fw-bold"><?= number_format($acc["paid"]) ?> د.ع</div>
                    </div>

                    <div class="col-4">
                        <div class="text-danger">المتبقي</div>
                        <div class="fw-bold"><?= number_format($acc["remaining"]) ?> د.ع</div>
                    </div>
                </div>

                <?php 
                    $percent = ($acc["total_fee"] > 0 && $acc["paid"] > 0) 
                                ? round(($acc["paid"] / $acc["total_fee"]) * 100)
                                : 0;
                ?>
                <div class="progress mt-3">
                    <div class="progress-bar" style="width:<?= $percent ?>%;"></div>
                </div>

                <div class="text-center mt-1" style="font-size:13px;"><?= $percent ?>% مدفوع</div>
            </div>

            <!-- Timeline الأقساط -->
            <h6 class="mt-3 mb-2"><i class="bi bi-list-check"></i> جدول الأقساط</h6>

            <?php if (count($installments) == 0): ?>
                <div class="alert alert-secondary mt-2" style="font-size:13px;">
                    لا يوجد جدول أقساط مسجل حالياً.
                </div>
            <?php else: ?>
                <div class="timeline">
                    <?php foreach($installments as $i): ?>
                        <div class="timeline-item">

                            <div class="timeline-icon">
                                <?php
                                    if($i["status"]=="paid") echo '<i class="bi bi-check-circle-fill text-success"></i>';
                                    elseif($i["status"]=="late") echo '<i class="bi bi-x-octagon-fill text-danger"></i>';
                                    elseif($i["status"]=="partial") echo '<i class="bi bi-hourglass-split text-warning"></i>';
                                    else echo '<i class="bi bi-clock-fill text-secondary"></i>';
                                ?>
                            </div>

                            <div class="timeline-card">
                                <div class="d-flex justify-content-between" style="font-size:13px;">
                                    <div>
                                        <div class="text-info">القسط رقم</div>
                                        <div class="fw-bold">#<?= $i["installment_number"] ?></div>
                                    </div>

                                    <div>
                                        <div class="text-info">المبلغ</div>
                                        <div class="fw-bold text-success"><?= number_format($i["amount"]) ?> د.ع</div>
                                    </div>
                                </div>

                                <hr style="margin:8px 0;border-color:#1f2937;">

                                <div class="d-flex justify-content-between" style="font-size:12px;">
                                    <div>
                                        <div class="text-warning">تاريخ الاستحقاق</div>
                                        <div><?= $i["due_date"] ?></div>
                                    </div>

                                    <div>
                                        <div class="text-info">الحالة</div>

                                        <?php if($i["status"]=="paid"): ?>
                                            <span class="badge bg-success">مدفوع</span>
                                        <?php elseif($i["status"]=="late"): ?>
                                            <span class="badge bg-danger">متأخر</span>
                                        <?php elseif($i["status"]=="partial"): ?>
                                            <span class="badge bg-warning text-dark">دفع جزئي</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">انتظار</span>
                                        <?php endif; ?>

                                    </div>
                                </div>

                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <!-- قسم صور الوصولات -->
            <h6 class="mt-3 mb-2"><i class="bi bi-receipt-cutoff"></i> وصولات الدفع</h6>

            <?php if (count($payments) == 0): ?>
                <div class="alert alert-secondary mt-2" style="font-size:13px;">
                    لا يوجد وصولات مسجلة.
                </div>
            <?php endif; ?>

            <?php foreach($payments as $p): ?>
                <div class="receipt-card">
                    <div class="fw-bold text-info">وصل رقم: <?= $p["receipt_number"] ?: "—" ?></div>
                    <div class="text-success">المبلغ: <?= number_format($p["amount"]) ?> د.ع</div>
                    <div class="text-light small mt-1"><?= $p["paid_at"] ?></div>

                    <?php if($p["receipt_image"]): ?>
                        <button class="btn btn-outline-light btn-sm mt-2" data-bs-toggle="modal" data-bs-target="#img<?= $p["id"] ?>">
                            <i class="bi bi-image"></i> عرض الصورة
                        </button>

                        <!-- Modal -->
                        <div class="modal fade" id="img<?= $p["id"] ?>" tabindex="-1">
                            <div class="modal-dialog modal-dialog-centered modal-lg">
                                <div class="modal-content bg-dark text-white">

                                    <div class="modal-header">
                                        <h5 class="modal-title">صورة الوصل</h5>
                                        <button class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>

                                    <div class="modal-body text-center">
                                        <img src="../uploads/receipts/<?= $p["receipt_image"] ?>" class="receipt-img">
                                    </div>

                                    <div class="modal-footer">
                                        <a href="../uploads/receipts/<?= $p["receipt_image"] ?>" download class="btn btn-success">
                                            تحميل
                                        </a>
                                        <button class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>

        <?php endif; ?>

    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>