<?php
session_start();
if(!isset($_SESSION["student_id"])) {
    header("Location: login.php"); exit;
}

require_once "../config/db.php";

$student_id = $_SESSION["student_id"];

// جلب الدفعات
$stmt = $conn->prepare("
    SELECT id, amount, receipt_number, receipt_image, payment_type, notes, paid_at
    FROM payments
    WHERE student_id=?
    ORDER BY paid_at DESC
");
$stmt->execute([$student_id]);
$payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
<meta charset="UTF-8">
<title>دفعاتي</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>

body {
    margin:0;
    background:#020617;
    color:white;
    font-family:"Tajawal";
}

/* غلاف يشبه تطبيق */
.app-shell {
    min-height:100vh;
    max-width:480px;
    margin:auto;
    padding-bottom:90px;
    background:linear-gradient(180deg,#0f172a,#020617);
}

/* هيدر */
.navbar-custom {
    background:rgba(15,23,42,0.9);
    padding:16px;
    display:flex;
    justify-content:space-between;
    align-items:center;
    border-bottom:1px solid rgba(255,255,255,0.12);
    backdrop-filter:blur(12px);
    position:sticky;
    top:0;
    z-index:10;
}

.title {
    font-size:20px;
    font-weight:800;
    display:flex;
    gap:8px;
    align-items:center;
}

.back-btn {
    width:42px;
    height:42px;
    border-radius:50%;
    background:#0f172a;
    border:1px solid rgba(148,163,184,0.45);
    display:flex;
    justify-content:center;
    align-items:center;
    color:white;
    font-size:22px;
    text-decoration:none;
}

/* بطاقة الدفع */
.payment-card {
    background:rgba(255,255,255,0.07);
    border:1px solid rgba(255,255,255,0.12);
    padding:20px;
    border-radius:20px;
    margin-bottom:20px;
    backdrop-filter:blur(8px);
    box-shadow:0 5px 25px rgba(0,0,15,0.45);
    animation:fadeIn .5s ease;
}

/* العناوين */
.label {
    color:#94a3b8;
    font-size:14px;
}

.value {
    font-size:18px;
    font-weight:800;
}

/* Notes */
.note-box {
    margin-top:12px;
    padding:10px;
    background:rgba(234,179,8,0.1);
    border-radius:12px;
    border:1px solid rgba(234,179,8,0.35);
}

/* Image */
.receipt-img {
    width:100%;
    border-radius:16px;
}

/* Modal */
.modal-content {
    background:#0f172a;
    color:white;
    border-radius:20px;
}

/* Animation */
@keyframes fadeIn {
    from { opacity:0; transform:translateY(12px); }
    to   { opacity:1; transform:translateY(0); }
}

</style>
</head>

<body>

<div class="app-shell">

    <!-- الهيدر -->
    <div class="navbar-custom">
        <div class="title">
            <i class="bi bi-receipt-cutoff"></i> دفعاتي
        </div>
        <a href="dashboard.php" class="back-btn"><i class="bi bi-arrow-right-circle-fill"></i></a>
    </div>

    <div class="container mt-4">

<?php if (count($payments) == 0): ?>
    <div class="alert alert-secondary text-center fw-bold mt-4">
        لا توجد دفعات مسجلة حتى الآن.
    </div>
<?php else: ?>

    <?php foreach ($payments as $p): ?>

        <div class="payment-card">

            <div class="row text-center">

                <div class="col-6 mb-3">
                    <div class="label">المبلغ</div>
                    <div class="value text-success"><?= number_format($p["amount"]) ?> د.ع</div>
                </div>

                <div class="col-6 mb-3">
                    <div class="label">رقم الوصل</div>
                    <div class="value text-primary"><?= $p["receipt_number"] ?: "—" ?></div>
                </div>

                <div class="col-6 mb-3">
                    <div class="label">نوع الدفع</div>
                    <span class="badge bg-info text-dark fw-bold"><?= $p["payment_type"] ?></span>
                </div>

                <div class="col-6 mb-3">
                    <div class="label">تاريخ الدفع</div>
                    <div class="value" style="font-size:16px;"><?= $p["paid_at"] ?></div>
                </div>

            </div>

            <?php if ($p["notes"]): ?>
                <div class="note-box">
                    <i class="bi bi-info-circle"></i> <?= $p["notes"] ?>
                </div>
            <?php endif; ?>

            <hr class="border-secondary">

            <div class="text-center">
                <?php if ($p["receipt_image"]): ?>
                    <button class="btn btn-outline-light btn-sm" data-bs-toggle="modal" data-bs-target="#img<?= $p["id"] ?>">
                        <i class="bi bi-image"></i> عرض صورة الوصل
                    </button>
                <?php else: ?>
                    <span class="text-secondary small">لا يوجد صورة وصل</span>
                <?php endif; ?>
            </div>

        </div>

        <!-- Modal -->
        <?php if ($p["receipt_image"]): ?>
        <div class="modal fade" id="img<?= $p["id"] ?>" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title">صورة الوصل</h5>
                        <button class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body text-center">
                        <img src="../uploads/receipts/<?= $p["receipt_image"] ?>" class="receipt-img">
                    </div>

                    <div class="modal-footer">
                        <a href="../uploads/receipts/<?= $p["receipt_image"] ?>" download class="btn btn-success">
                            <i class="bi bi-download"></i> تحميل
                        </a>
                        <button class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                    </div>

                </div>
            </div>
        </div>
        <?php endif; ?>

    <?php endforeach; ?>

<?php endif; ?>

    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>