<?php
session_start();
if(!isset($_SESSION["student_id"])) {
    header("Location: login.php"); 
    exit;
}

require_once "../config/db.php";

$student_id = intval($_SESSION["student_id"]);

// جلب جميع ملفات الطالب
$q = $conn->prepare("SELECT * FROM student_pdf WHERE student_id=? ORDER BY id DESC");
$q->execute([$student_id]);
$pdf_list = $q->fetchAll(PDO::FETCH_ASSOC);

// إنشاء مجلد الطالب إن لم يكن موجوداً
$student_dir = "../uploads/pdfs/" . $student_id . "/";
if (!is_dir($student_dir)) {
    mkdir($student_dir, 0777, true);
    chmod($student_dir, 0777);
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
<meta charset="UTF-8">
<title>استمارات PDF الخاصة بك</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>

body {
    margin:0;
    background:#020617;
    font-family:"Tajawal";
    color:white;
}

.app-shell {
    min-height:100vh;
    max-width:480px;
    margin:0 auto;
    background:radial-gradient(circle at top,#0f172a,#020617);
    box-shadow:0 0 35px rgba(0,0,0,0.7);
    position:relative;
}

.navbar-custom {
    background:rgba(15,23,42,0.95);
    padding:16px 18px;
    border-radius:0 0 18px 18px;
    display:flex;
    justify-content:space-between;
    align-items:center;
    border-bottom:1px solid rgba(148,163,184,0.25);
}

.title {
    font-size:18px;
    font-weight:800;
    color:#e2e8f0;
}

.pdf-box {
    background:rgba(255,255,255,0.08);
    padding:15px;
    border-radius:14px;
    margin:15px;
    border:1px solid rgba(255,255,255,0.18);
}

.pdf-name {
    font-size:15px;
    font-weight:bold;
    color:#93c5fd;
}

.pdf-date {
    font-size:13px;
    color:#cbd5e1;
}

</style>
</head>

<body>

<div class="app-shell">

    <div class="navbar-custom">
        <span class="title"><i class="bi bi-file-earmark-pdf"></i> مستندات PDF</span>
        <a href="dashboard.php" class="btn btn-light btn-sm">رجوع</a>
    </div>

    <?php if (count($pdf_list) == 0): ?>

        <div class="pdf-box text-center">
            <h5 class="pdf-name">لا توجد ملفات PDF حتى الآن</h5>
            <p class="pdf-date">عند رفع ملفات جديدة من الإدارة، ستظهر هنا تلقائياً.</p>
        </div>

    <?php else: ?>

        <?php foreach ($pdf_list as $pdf): 
            $full_path = "../" . $pdf["pdf_path"];
        ?>
        <div class="pdf-box">
            <div class="pdf-name"><i class="bi bi-filetype-pdf"></i> <?= htmlspecialchars($pdf["pdf_name"]) ?></div>
            <div class="pdf-date">📅 <?= $pdf["created_at"] ?></div>

            <a href="<?= $full_path ?>" target="_blank" class="btn btn-primary btn-sm mt-2 w-100">
                عرض الملف
            </a>

            <a href="<?= $full_path ?>" download class="btn btn-success btn-sm mt-2 w-100">
                تحميل الملف
            </a>
        </div>
        <?php endforeach; ?>

    <?php endif; ?>

</div>

</body>
</html>