<?php
session_start();
require_once "../config/db.php";
require_once "../config/security.php";

if (!isset($_SESSION['student_id'])) {
    header("Location: login.php");
    exit;
}

$student_id = $_SESSION['student_id'];

// إنشاء مجلد الصور الشخصية
$avatar_dir = "../uploads/students/personal_photos/";
if (!is_dir($avatar_dir)) {
    mkdir($avatar_dir, 0777, true);
    chmod($avatar_dir, 0777);
}

$avatar_path = $avatar_dir . "profile_pic_" . $student_id . ".jpg";

// جلب بيانات الطالب
$stmt = $conn->prepare("SELECT * FROM students WHERE id=? LIMIT 1");
$stmt->execute([$student_id]);
$student = $stmt->fetch(PDO::FETCH_ASSOC);

$success = "";
$error = "";

// تحديث البيانات
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $parent_phone  = sanitize($_POST['parent_phone']);
    $email         = sanitize($_POST['email']);

    // رفع صورة جديدة
    if (!empty($_FILES['avatar']['name'])) {

        $ext = strtolower(pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION));
        $allowed = ["jpg","jpeg","png","webp"];

        if (!in_array($ext, $allowed)) {
            $error = "❌ الصيغ المسموحة: JPG - PNG - WEBP";
        } else {
            move_uploaded_file($_FILES['avatar']['tmp_name'], $avatar_path);
            chmod($avatar_path, 0777);
            $success = "✔ تم تحديث صورتك الشخصية!";
        }
    }

    // تحديث البيانات الأخرى
    if (!$error) {
        $stmt2 = $conn->prepare("
            UPDATE students SET 
                guardian_phone1=?,
                email=?
            WHERE id=?
        ");
        $stmt2->execute([$parent_phone, $email, $student_id]);

        if (!$success) {
            $success = "✔ تم تحديث بياناتك بنجاح!";
        }
    }
}

$avatar_exists = file_exists($avatar_path);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>الملف الشخصي</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet"
href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>

body {
    margin:0;
    padding:0;
    background:#020617;
    font-family:"Tajawal", sans-serif;
    color:white;
}

.app-shell {
    min-height:100vh;
    max-width:480px;
    margin:0 auto;
    background:radial-gradient(circle at top, #0f172a, #020617);
    display:flex;
    flex-direction:column;
    box-shadow:0 0 35px rgba(0,0,0,0.7);
}

/* هيدر ثابت */
.navbar-custom {
    background:linear-gradient(135deg,#1e293b,#2563eb);
    padding:15px 18px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    border-radius:0 0 16px 16px;
    position:sticky;
    top:0;
    z-index:20;
    box-shadow:0 4px 20px rgba(0,0,0,0.45);
}
.navbar-custom .title {
    font-size:16px;
    font-weight:700;
    color:#bfdbfe;
}
.navbar-custom a {
    color:white;
    font-size:18px;
}

.container-app {
    padding:18px 14px 70px;
}

/* كارت زجاجي */
.card-glass {
    background:rgba(255,255,255,0.06);
    border-radius:18px;
    padding:20px;
    border:1px solid rgba(255,255,255,0.12);
    backdrop-filter:blur(10px);
    margin-bottom:20px;
    box-shadow:0 8px 25px rgba(0,0,0,0.45);
}

/* صورة */
.profile-avatar {
    width:120px;
    height:120px;
    border-radius:50%;
    object-fit:cover;
    border:4px solid rgba(255,255,255,0.30);
    box-shadow:0 0 18px rgba(96,165,250,0.7);
}

/* عنوان قسم */
.section-title {
    font-size:15px;
    font-weight:700;
    color:#93c5fd;
    margin-bottom:10px;
}

/* الحقول */
.form-control {
    background:rgba(255,255,255,0.10);
    border:1px solid rgba(255,255,255,0.15);
    color:white;
    border-radius:14px;
}

/* زر */
.btn-save {
    background:linear-gradient(90deg,#3b82f6,#6366f1);
    border:0;
    padding:12px;
    font-size:17px;
    border-radius:14px;
    font-weight:700;
    color:white;
    margin-top:10px;
}

</style>
</head>
<body>

<div class="app-shell">

    <!-- هيدر -->
    <div class="navbar-custom">
        <span class="title"><i class="bi bi-person-circle"></i> الملف الشخصي</span>
        <a href="dashboard.php"><i class="bi bi-arrow-right"></i></a>
    </div>

    <div class="container-app">

        <!-- صورة واسم -->
        <div class="card-glass text-center">
            <img src="<?= $avatar_exists ? $avatar_path : '../assets/images/profile.png' ?>" class="profile-avatar">
            <h5 class="mt-3"><?= htmlspecialchars($student["full_name"]) ?></h5>
            <div style="opacity:.7;font-size:13px"><?= $student["phone"] ?></div>
        </div>

        <!-- معلومات ثابتة -->
        <div class="card-glass">
            <div class="section-title">المعلومات الأكاديمية</div>

            <div><span style="color:#38bdf8">الجامعة: </span><?= $student["university_name"] ?></div>
            <div><span style="color:#38bdf8">القسم: </span><?= $student["college_name"] ?></div>
            <div><span style="color:#38bdf8">نوع الدراسة: </span><?= $student["study_type"] ?></div>
            <div><span style="color:#38bdf8">الرقم الامتحاني: </span><?= $student["exam_number"] ?></div>
        </div>

        <!-- تعديل بيانات -->
        <div class="card-glass">
            <div class="section-title">تحديث معلومات الاتصال</div>

            <?php if ($success): ?>
                <div class="alert alert-success text-dark fw-bold"><?= $success ?></div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-danger fw-bold"><?= $error ?></div>
            <?php endif; ?>

            <form method="POST" enctype="multipart/form-data">

                <label>رقم ولي الأمر</label>
                <input type="text" name="parent_phone"
                       class="form-control mb-3"
                       value="<?= htmlspecialchars($student['guardian_phone1']) ?>">

                <label>البريد الإلكتروني</label>
                <input type="email" name="email"
                       class="form-control mb-3"
                       value="<?= htmlspecialchars($student['email']) ?>">

                <label>صورتك الشخصية</label>
                <input type="file" name="avatar" class="form-control mb-3">

                <button class="btn-save w-100">
                    <i class="bi bi-save"></i> حفظ التعديلات
                </button>

            </form>
        </div>

    </div>

</div>

</body>
</html>