<?php
session_start();
if (!isset($_SESSION["finance_user"])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "../config/app.php";
require_once "includes/header.php";
require_once "includes/navbar.php";

if (!isset($_GET["id"])) {
    die("❌ Student ID missing");
}

$student_id = intval($_GET["id"]);

/* ============================================================
   1) جلب بيانات الطالب + الحساب المالي
============================================================ */
$q = $conn->prepare("
    SELECT 
        s.id,
        s.full_name,
        s.phone,
        s.college_name,
        s.study_type,
        s.admission_channel,

        a.id           AS acc_id,
        a.total_fee,
        a.discount,
        a.paid,
        a.remaining,
        a.level,
        a.payment_plan,
        a.due_date,
        a.last_update

    FROM students s
    LEFT JOIN accounts a ON a.student_id = s.id
    WHERE s.id = ?
    LIMIT 1
");
$q->execute([$student_id]);
$data = $q->fetch(PDO::FETCH_ASSOC);

if (!$data) {
    die("❌ Student not found");
}

/* ============================================================
   2) حالة الحساب
============================================================ */
$is_paid_full   = ($data["remaining"] <= 0);
$status_badge   = $is_paid_full ? "success" : "danger";
$status_message = $is_paid_full ? "✔ الطالب مسدد بالكامل" : "❗ الطالب غير مسدد";

/* ============================================================
   3) جلب جدول الأقساط التفصيلي
============================================================ */
$schedule_stmt = $conn->prepare("
    SELECT *
    FROM installment_schedule
    WHERE account_id = ?
    ORDER BY installment_number ASC
");
$schedule_stmt->execute([$data["acc_id"]]);
$schedule = $schedule_stmt->fetchAll(PDO::FETCH_ASSOC);

$has_schedule = count($schedule) > 0;

/* ============================================================
   4) إعداد الخصم + التقسيط
============================================================ */
$current_discount   = (int)($data["discount"] ?? 0);
$current_plan       = $data["payment_plan"] ?? "دفعة واحدة";
$total_fee_original = (int)$data["total_fee"];
$remaining_amount   = (int)$data["remaining"];
$first_due_default  = $data["due_date"] ?: date("Y-m-d", strtotime("+30 days"));

$plan_options = [
    "دفعة واحدة" => 1,
    "دفعتين"     => 2,
    "3 دفعات"    => 3,
    "4 دفعات"    => 4,
    "5 دفعات"    => 5,
    "6 دفعات"    => 6,
];

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إضافة دفعة جديدة</title>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

<style>
body{
    background:#0f172a;
    color:#e5e7eb;
    font-family:"Tajawal", sans-serif;
}
.card-glass{
    background:rgba(15,23,42,0.88);
    border:1px solid #1f2937;
    padding:22px;
    border-radius:18px;
    margin-bottom:20px;
    box-shadow:0 20px 40px rgba(0,0,0,0.55);
    backdrop-filter:blur(14px);
    transition:0.3s;
}
.card-glass:hover{
    transform:translateY(-3px);
    box-shadow:0 25px 50px rgba(0,0,0,0.65);
}
.label-title{
    font-weight:700;
    color:#cbd5e1;
}
.preview-box{
    display:none;
    border:1px solid #555;
    border-radius:10px;
    padding:5px;
    margin-top:10px;
}
.preview-box img{
    width:100%;
    border-radius:10px;
}
#cameraModal video{
    width:100%;
    border-radius:12px;
}
.note-cell{
    text-align:right;
}
.note-main{
    font-size:0.9rem;
}
.note-log{
    font-size:0.8rem;
}
.note-log i{
    font-size:0.9rem;
}
</style>
</head>

<body>

<div class="container mt-4">

    <h2 class="mb-3">
        <i class="bi bi-cash-stack"></i> إضافة دفعة جديدة
    </h2>

    <div class="mb-3">
        <span class="badge bg-<?= $status_badge ?> fs-6 px-3 py-2">
            <?= $status_message ?>
        </span>
    </div>

    <?php if ($is_paid_full): ?>
        <div class="alert alert-success fw-bold text-center">
            ✔ الطالب مسدد بالكامل — لا يمكن إضافة دفعات جديدة  
            <br> ✦ لتفعيل الدفعات، قم بترقية المرحلة من صفحة الملف المالي.
        </div>
    <?php endif; ?>

    <!-- ============================================================
            (1) بيانات الطالب
    ============================================================= -->
    <div class="card-glass">
        <h4 class="mb-3"><i class="bi bi-person-badge"></i> بيانات الطالب</h4>
        <hr>

        <div class="row mb-2">
            <div class="col-md-4">
                <label class="label-title">اسم الطالب</label>
                <input type="text" class="form-control" value="<?= $data['full_name'] ?>" readonly>
            </div>

            <div class="col-md-4">
                <label class="label-title">القسم</label>
                <input type="text" class="form-control" value="<?= $data['college_name'] ?>" readonly>
            </div>

            <div class="col-md-4">
                <label class="label-title">القناة</label>
                <input type="text" class="form-control" value="<?= $data['admission_channel'] ?>" readonly>
            </div>
        </div>

        <div class="row mb-2">

            <div class="col-md-3">
                <label class="label-title">المرحلة الحالية</label>
                <input type="text" class="form-control" value="<?= $data['level'] ?>" readonly>
            </div>

            <div class="col-md-3">
                <label class="label-title">القسط الكلي</label>
                <input type="text" class="form-control" value="<?= number_format($total_fee_original) ?>" readonly>
            </div>

            <div class="col-md-3">
                <label class="label-title">المدفوع</label>
                <input type="text" class="form-control text-success fw-bold"
                       value="<?= number_format($data['paid']) ?>" readonly>
            </div>

            <div class="col-md-3">
                <label class="label-title">المتبقي</label>
                <input type="text" class="form-control text-danger fw-bold"
                       value="<?= number_format($remaining_amount) ?>" readonly>
            </div>

        </div>

    </div>

    <!-- ============================================================
            (2) إعداد الخصم والتقسيط
    ============================================================= -->
    <div class="card-glass">
        <h4 class="mb-3"><i class="bi bi-calculator"></i> الخصم والتقسيط</h4>
        <hr>

        <form action="add_payment_save.php" method="POST" enctype="multipart/form-data">

            <input type="hidden" name="student_id" value="<?= $student_id ?>">
            <input type="hidden" name="account_id" value="<?= $data['acc_id'] ?>">

            <div class="row mb-3">

                <div class="col-md-3">
                    <label class="label-title">نسبة الخصم %</label>
                    <input type="number" name="discount" id="discount"
                           class="form-control"
                           value="<?= $current_discount ?>"
                           min="0" max="100"
                           <?= $is_paid_full?'disabled':'' ?>>
                </div>

                <div class="col-md-3">
                    <label class="label-title">خطة التقسيط</label>
                    <select name="payment_plan" id="payment_plan"
                            class="form-select" <?= $is_paid_full?'disabled':'' ?>>
                        <?php foreach ($plan_options as $label => $count): ?>
                            <option value="<?= $label ?>" <?= ($current_plan == $label)?'selected':'' ?>>
                                <?= $label ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="label-title">عدد الدفعات</label>
                    <input type="text" id="installments_count" class="form-control" readonly>
                </div>

                <div class="col-md-3">
                    <label class="label-title">مبلغ كل قسط</label>
                    <input type="text" id="installment_amount" class="form-control" readonly>
                </div>

            </div>

            <div class="row mb-3">

                <div class="col-md-4">
                    <label class="label-title">القسط بعد الخصم</label>
                    <input type="text" id="total_after_discount" class="form-control" readonly>
                </div>

                <div class="col-md-4">
                    <label class="label-title">أول تاريخ استحقاق</label>
                    <input type="date" id="first_due_date" name="first_due_date"
                           class="form-control"
                           value="<?= $first_due_default ?>"
                           <?= $is_paid_full?'disabled':'' ?>>
                </div>

                <div class="col-md-4">
                    <label class="label-title">ملاحظة</label>
                    <input type="text" name="plan_note" class="form-control">
                </div>

            </div>

            <hr>

            <!-- ============================================================
                    (3) تفاصيل الدفعة
            ============================================================= -->
            <h5 class="mb-3"><i class="bi bi-cash-coin"></i> تفاصيل الدفعة</h5>

            <div class="row mb-3">

                <div class="col-md-3">
                    <label class="label-title">المبلغ</label>
                    <input type="number" required name="amount"
                           class="form-control" <?= $is_paid_full?'disabled':'' ?>>
                </div>

                <div class="col-md-3">
                    <label class="label-title">نوع الدفع</label>
                    <select name="payment_type" class="form-select" <?= $is_paid_full?'disabled':'' ?>>
                        <option value="نقدي">نقدي</option>
                        <option value="إلكتروني">إلكتروني</option>
                        <option value="حوالة">حوالة</option>
                        <option value="منحة">منحة</option>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="label-title">رقم الوصل</label>
                    <input type="text" required name="receipt_number"
                           class="form-control" <?= $is_paid_full?'disabled':'' ?>>
                </div>

                <!-- ====================================================
                     نظام التقاط الصورة مثل الموبايل + معاينة + إعادة التقاط 
                ===================================================== -->
                <div class="col-md-3">
                    <label class="label-title">صورة الوصل</label>

                    <!-- زر الكاميرا -->
                    <button type="button" 
                            class="btn btn-primary w-100" 
                            onclick="openCamera()">
                        📷 فتح الكاميرا
                    </button>

                    <!-- الحقل الحقيقي -->
                    <input type="file" 
                           name="receipt_image" 
                           id="imageInput"
                           accept="image/*"
                           class="d-none">

                    <!-- المعاينة -->
                    <div class="preview-box" id="previewBox">
                        <img id="previewImg" src="">
                    </div>

                    <!-- إزالة / إعادة التقاط -->
                    <button type="button" 
                            id="removeImageBtn"
                            class="btn btn-danger w-100 mt-2"
                            style="display:none;">
                        🔄 إعادة الالتقاط
                    </button>

                </div>

            </div>

            <div class="row">
                <div class="col-12">
                    <label class="label-title">ملاحظات</label>
                    <input type="text" name="notes" class="form-control">
                </div>
            </div>

            <button class="btn btn-success btn-lg w-100 mt-4" <?= $is_paid_full?'disabled':'' ?>>
                <i class="bi bi-check2-circle"></i> حفظ الدفعة
            </button>

        </form>

    </div>

    <!-- ============================================================
            (4) جدول الأقساط الحالي
    ============================================================= -->
    <!-- ============================================================
        (4) جدول الأقساط الحالي — محدث بالكامل
============================================================ -->
<div class="card-glass">
    <h4><i class="bi bi-calendar3"></i> جدول الأقساط</h4>
    <hr>

    <?php if (!$has_schedule): ?>
        <p class="text-warning fw-bold">⚠ لا يوجد جدول أقساط حالي.</p>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-dark text-center align-middle">
                <thead>
                <tr>
                    <th>القسط</th>
                    <th>المبلغ</th>
                    <th>الاستحقاق</th>
                    <th>المدفوع</th>
                    <th>تاريخ السداد</th>
                    <th>الحالة</th>
                    <th>الملاحظات</th>
                    <th>تعديل الاستحقاق</th>
                </tr>
                </thead>
                <tbody>

                <?php foreach ($schedule as $s): ?>

                    <?php
                    /* --------------------------------------------------------
                       جلب كل تعديلات تاريخ الاستحقاق + اسم الموظف
                    -------------------------------------------------------- */
                    $log_stmt = $conn->prepare("
                        SELECT 
                            l.old_due_date,
                            l.new_due_date,
                            l.reason,
                            l.changed_at,
                            fu.name AS changed_by_name
                        FROM due_date_logs l
                        LEFT JOIN finance_users fu ON fu.id = l.changed_by
                        WHERE l.schedule_id = ?
                        ORDER BY l.changed_at DESC
                    ");
                    $log_stmt->execute([$s['id']]);
                    $logs = $log_stmt->fetchAll(PDO::FETCH_ASSOC);
                    ?>

                    <tr>
                        <td><?= $s['installment_number'] ?></td>
                        <td><?= number_format($s['amount']) ?> د.ع</td>
                        <td><?= $s['due_date'] ?></td>
                        <td><?= number_format($s['paid_amount']) ?></td>
                        <td><?= $s['paid_date'] ?: "—" ?></td>

                        <td>
                            <?php if ($s["status"]==="paid"): ?>
                                <span class="badge bg-success">مدفوع</span>
                            <?php elseif ($s["status"]==="late"): ?>
                                <span class="badge bg-danger">متأخر</span>
                            <?php elseif ($s["status"]==="partial"): ?>
                                <span class="badge bg-warning">جزئي</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">انتظار</span>
                            <?php endif; ?>
                        </td>

                        <!-- ============================================================
                                (الملاحظات) — محدثة بالكامل
                        ============================================================= -->
                        <td class="note-cell text-start">

                            <!-- ملاحظة القسط الأساسية -->
                            <?php if (!empty($s['notes'])): ?>
                                <div class="note-main text-info mb-1">
                                    <i class="bi bi-journal-text"></i>
                                    <?= htmlspecialchars($s['notes'], ENT_QUOTES, 'UTF-8') ?>
                                </div>
                            <?php endif; ?>

                            <!-- سجل تعديلات الاستحقاق -->
                            <?php if (!empty($logs)): ?>
                                <?php foreach ($logs as $lg): ?>
                                    <div class="note-log border-bottom border-secondary pb-1 mb-1">

                                        <div>
                                            <i class="bi bi-clock-history text-warning"></i>
                                            <b>تعديل الاستحقاق:</b>
                                            من <?= $lg['old_due_date'] ?> → <?= $lg['new_due_date'] ?>
                                        </div>

                                        <div>
                                            <i class="bi bi-chat-left-text text-info"></i>
                                            <b>السبب:</b>
                                            <?= htmlspecialchars($lg['reason'], ENT_QUOTES, 'UTF-8') ?>
                                        </div>

                                        <div>
                                            <i class="bi bi-person-badge text-primary"></i>
                                            <b>بواسطة:</b>
                                            <?= $lg['changed_by_name'] ?: "غير معروف" ?>
                                        </div>

                                        <div class="text-muted small">
                                            <i class="bi bi-calendar3"></i>
                                            <?= $lg['changed_at'] ?>
                                        </div>

                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <?php if (empty($s['notes'])): ?>
                                    —
                                <?php endif; ?>
                            <?php endif; ?>

                        </td>

                        <td>
                            <button type="button"
                                    class="btn btn-warning btn-sm"
                                    onclick="openDueEdit(<?= $s['id'] ?>)">
                                <i class="bi bi-pencil-square"></i> تعديل
                            </button>
                        </td>

                    </tr>

                <?php endforeach; ?>

                </tbody>
            </table>
        </div>
    <?php endif; ?>

</div>

</div>

<!-- ============================================================
      مودال الكاميرا
============================================================ -->
<div class="modal fade" id="cameraModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content" style="background:#0f172a;color:white;border:1px solid #334155;">

      <div class="modal-header">
        <h5 class="modal-title">📸 التقاط الصورة</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body text-center">

        <video id="camera" autoplay playsinline></video>

        <button id="captureBtn" class="btn btn-warning mt-3">📸 التقط</button>

        <canvas id="canvas" style="display:none;"></canvas>

        <button id="useBtn" class="btn btn-success mt-3" style="display:none;">✔ استخدام</button>
        <button id="retakeBtn" class="btn btn-danger mt-3" style="display:none;">🔄 إعادة الالتقاط</button>

      </div>

    </div>
  </div>
</div>

<!-- ============================================================
      مودال تعديل تاريخ الاستحقاق + سبب التعديل
============================================================ -->
<div class="modal fade" id="editDueModal" tabindex="-1">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content" style="background:#0f172a;color:white;border:1px solid #334155;border-radius:18px;">

      <div class="modal-header">
        <h5 class="modal-title">🗓️ تعديل تاريخ الاستحقاق</h5>
        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>

      <form action="update_due_date.php" method="POST">
        <div class="modal-body">

          <input type="hidden" name="schedule_id" id="modal_schedule_id">
          <input type="hidden" name="student_id" value="<?= $student_id ?>">
          <input type="hidden" name="account_id" value="<?= $data['acc_id'] ?>">

          <div class="mb-3">
            <label class="form-label">التاريخ الجديد</label>
            <input type="date" class="form-control" name="new_due_date" required>
          </div>

          <div class="mb-3">
            <label class="form-label">سبب التعديل</label>
            <textarea class="form-control" name="reason" rows="3" placeholder="مثال: طلب الطالب بسبب ظرف صحي" required></textarea>
          </div>

        </div>

        <div class="modal-footer">
          <button class="btn btn-success w-100 fw-bold">✔ حفظ التعديل</button>
        </div>
      </form>

    </div>
  </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
const TOTAL = <?= $total_fee_original ?>;

// حسابات الخصم
function getCount(label){
    switch(label){
        case "دفعة واحدة":return 1;
        case "دفعتين":return 2;
        case "3 دفعات":return 3;
        case "4 دفعات":return 4;
        case "5 دفعات":return 5;
        case "6 دفعات":return 6;
    }
    return 1;
}

function recalc(){
    let discount = parseInt(document.getElementById("discount").value)||0;
    if(discount<0)discount=0;
    if(discount>100)discount=100;

    const plan = document.getElementById("payment_plan").value;
    const count = getCount(plan);

    const after = Math.round(TOTAL - (TOTAL * (discount/100)));
    const per   = Math.round(after / count);

    document.getElementById("installments_count").value = count;
    document.getElementById("installment_amount").value = per.toLocaleString()+" د.ع";
    document.getElementById("total_after_discount").value = after.toLocaleString()+" د.ع";
}

document.addEventListener("DOMContentLoaded", ()=>{
    recalc();
    document.getElementById("discount").oninput = recalc;
    document.getElementById("payment_plan").onchange = recalc;
});


// ================================================================
//        ( A ) كاميرا — يدعم كل الأجهزة (موبايل + كمبيوتر USB)
// ================================================================
let stream;

function openCamera(){
    let modal = new bootstrap.Modal(document.getElementById("cameraModal"));
    modal.show();

    navigator.mediaDevices.getUserMedia({
        video: { facingMode: "environment" },
        audio:false
    }).then(s=>{
        stream = s;
        document.getElementById("camera").srcObject = s;
    }).catch(()=>{
        alert("⚠ الكاميرا غير متاحة أو تم رفض الإذن.");
    });
}

document.getElementById("captureBtn").onclick = function(){
    const video = document.getElementById("camera");
    const canvas = document.getElementById("canvas");

    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;

    canvas.getContext("2d").drawImage(video,0,0);

    video.style.display = "none";
    canvas.style.display = "block";

    document.getElementById("useBtn").style.display = "inline-block";
    document.getElementById("retakeBtn").style.display = "inline-block";
}

document.getElementById("retakeBtn").onclick = function(){
    const video = document.getElementById("camera");
    const canvas = document.getElementById("canvas");

    canvas.style.display = "none";
    video.style.display = "block";

    document.getElementById("useBtn").style.display = "none";
    document.getElementById("retakeBtn").style.display = "none";

    navigator.mediaDevices.getUserMedia({
        video:true
    }).then(s=>{
        stream = s;
        video.srcObject = s;
    });
}

document.getElementById("useBtn").onclick = function(){
    const canvas = document.getElementById("canvas");

    canvas.toBlob(function(blob){

        let file = new File([blob], "receipt.jpg", { type:"image/jpeg" });

        let input = document.getElementById("imageInput");
        let dt = new DataTransfer();
        dt.items.add(file);
        input.files = dt.files;

        document.getElementById("previewImg").src = URL.createObjectURL(blob);
        document.getElementById("previewBox").style.display = "block";
        document.getElementById("removeImageBtn").style.display = "block";

        stream.getTracks().forEach(t=>t.stop());

        bootstrap.Modal.getInstance(document.getElementById("cameraModal")).hide();
    }, "image/jpeg", 0.9);
};


// ================================================================
//                ( B ) حذف الصورة من المعاينة
// ================================================================
document.getElementById("removeImageBtn").onclick = function(){
    document.getElementById("imageInput").value = "";
    document.getElementById("previewBox").style.display = "none";
    this.style.display = "none";
};

// ================================================================
//                ( C ) فتح مودال تعديل الاستحقاق
// ================================================================
function openDueEdit(id){
    document.getElementById('modal_schedule_id').value = id;
    new bootstrap.Modal(document.getElementById('editDueModal')).show();
}
</script>

</body>
</html>
