<?php
require_once "../config/db.php";
require_once "../config/app.php";

function update_account($student_id){
    global $conn;

    // مجموع المدفوعات
    $paid = $conn->prepare("SELECT SUM(amount) FROM payments WHERE student_id=?");
    $paid->execute([$student_id]);
    $total_paid = $paid->fetchColumn() ?? 0;

    // جلب المبلغ الكلي
    $acc = $conn->prepare("SELECT total_fee FROM accounts WHERE student_id=?");
    $acc->execute([$student_id]);
    $total_fee = $acc->fetchColumn() ?? 0;

    // حساب المتبقي
    $remaining = $total_fee - $total_paid;

    // تحديث الحساب
    $update = $conn->prepare("UPDATE accounts SET paid=?, remaining=? WHERE student_id=?");
    $update->execute([$total_paid, $remaining, $student_id]);
}
?>