<?php
session_start();
if (!isset($_SESSION["finance_user"])) {
    header("Location: login.php");
    exit;
}

require_once "../config/db.php";
require_once "../config/app.php";

/* ============================================================
   📌 معلومات الموظف المستخرج للتقرير
============================================================ */
$employee = $_SESSION["finance_user"];

/* ============================================================
   📌 استقبال فلاتر التصدير
============================================================ */

$name_filter    = $_GET["name"] ?? "";
$college_filter = $_GET["college"] ?? "";
$study_filter   = $_GET["study"] ?? "";

/* ============================================================
   📌 بناء شروط الفلاتر للداتا
============================================================ */

$where = "
    a.remaining > 0
    AND a.due_date IS NOT NULL
    AND a.due_date < CURDATE()
";

$params = [];

// FILTER — NAME
if (!empty($name_filter)) {
    $where .= " AND s.full_name LIKE ?";
    $params[] = "%$name_filter%";
}

// FILTER — COLLEGE
if (!empty($college_filter)) {
    $where .= " AND s.college_name = ?";
    $params[] = $college_filter;
}

// FILTER — STUDY TYPE
if (!empty($study_filter)) {
    $where .= " AND s.study_type = ?";
    $params[] = $study_filter;
}

/* ============================================================
   📌 تشغيل الاستعلام مع الفلاتر
============================================================ */

$sql = "
    SELECT 
        s.full_name,
        s.phone,
        s.college_name,
        s.study_type,
        a.remaining,
        a.due_date,
        DATEDIFF(CURDATE(), a.due_date) AS days_late
    FROM accounts a
    JOIN students s ON s.id = a.student_id
    WHERE $where
    ORDER BY days_late DESC
";

$stmt = $conn->prepare($sql);
$stmt->execute($params);

$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ============================================================
   📌 التاريخ والوقت مع اليوم بالعربي
============================================================ */

$days_ar = [
    "Monday" => "الاثنين",
    "Tuesday" => "الثلاثاء",
    "Wednesday" => "الأربعاء",
    "Thursday" => "الخميس",
    "Friday" => "الجمعة",
    "Saturday" => "السبت",
    "Sunday" => "الأحد"
];

$day_ar = $days_ar[date("l")];
$date = date("Y-m-d");
$time = date("h:i A");

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">

<title>تقرير الطلاب المتأخرين</title>

<style>

@page { margin: 35px; }

body {
    font-family: "Tajawal", sans-serif;
    color: #111;
    direction: rtl;
    font-size: 15px;
}

.container {
    width: 100%;
    margin: 0 auto;
    padding: 5px;
}

/* ================== HEADER ================== */

.header {
    text-align: center;
    margin-bottom: 25px;
}

.header img {
    width: 120px;
    margin-bottom: 8px;
}

.header-title {
    font-size: 26px;
    font-weight: bold;
}

.header-sub {
    font-size: 18px;
    color: #444;
}

/* ================== INFO BOX ================== */

.info-box {
    background: #f1f5f9;
    border-radius: 12px;
    padding: 15px;
    line-height: 1.9;
    margin-bottom: 20px;
    border: 1px solid #cbd5e1;
    font-size: 15px;
}

/* ================== TABLE ================== */

.table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    font-size: 14px;
}

.table th {
    background: #1e293b;
    color: white;
    padding: 9px;
    font-size: 15px;
}

.table td {
    border: 1px solid #cbd5e1;
    padding: 9px;
}

.table tr:nth-child(even) { background: #f8fafc; }
.table tr:nth-child(odd) { background: #ffffff; }

/* منع تقطيع الصفوف بين الصفحات */
.table td, .table th {
    page-break-inside: avoid;
}

/* ================== PRINT BUTTON ================== */

.print-btn {
    display: block;
    margin: 20px auto;
    padding: 12px 20px;
    width: 220px;
    text-align: center;
    background: #2563eb;
    color: white;
    font-size: 17px;
    border-radius: 10px;
    cursor: pointer;
}

@media print {
    .print-btn { display: none; }
}

</style>

</head>
<body>

<div class="container">

    <!-- HEADER -->
    <div class="header">
        <img src="../assets/img/logo.png">
        <div class="header-title">جامعة النبراس الأهلية</div>
        <div class="header-sub">قسم الشؤون المالية — تقرير الطلاب المتأخرين عن السداد</div>
    </div>

    <!-- INFO BOX -->
    <div class="info-box">
        <strong>معلومات التقرير:</strong><br>

        • الموظف: <strong><?= htmlspecialchars($employee) ?></strong><br>
        • اليوم: <strong><?= $day_ar ?></strong><br>
        • التاريخ: <strong><?= $date ?></strong><br>
        • الوقت: <strong><?= $time ?></strong><br><br>

        • عدد الطلاب في التقرير: <strong><?= count($rows) ?></strong>
    </div>

    <!-- TABLE -->
    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>اسم الطالب</th>
                <th>القسم</th>
                <th>نوع الدراسة</th>
                <th>الهاتف</th>
                <th>المبلغ المتأخر</th>
                <th>الأيام المتأخرة</th>
                <th>تاريخ الاستحقاق</th>
            </tr>
        </thead>

        <tbody>
        <?php foreach ($rows as $i => $r): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td><?= htmlspecialchars($r['full_name']) ?></td>
                <td><?= htmlspecialchars($r['college_name']) ?></td>
                <td><?= htmlspecialchars($r['study_type']) ?></td>
                <td><?= htmlspecialchars($r['phone']) ?></td>
                <td><?= number_format($r['remaining']) ?></td>
                <td><?= $r['days_late'] ?> يوم</td>
                <td><?= $r['due_date'] ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <!-- PRINT BUTTON -->
    <button class="print-btn" onclick="window.print()">
        🖨 طباعة / حفظ PDF
    </button>

</div>

</body>
</html>