<?php
session_start();
require_once "../config/db.php";
require_once "../config/app.php";

$error = "";

if ($_SERVER['REQUEST_METHOD'] == "POST") {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);

    $stmt = $conn->prepare("SELECT * FROM finance_users WHERE username=? LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {

        $_SESSION['finance_user'] = [
            "id" => $user['id'],
            "name" => $user['name'],
            "username" => $user['username']
        ];

        header("Location: dashboard.php");
        exit;
    } else {
        $error = "❌ اسم المستخدم أو كلمة المرور غير صحيحة";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تسجيل دخول الحسابات</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
    background:#0f172a;
    color:white;
    font-family:Tajawal;
}
.login-box{
    width:380px;
    margin:auto;
    margin-top:120px;
    background:#1e293b;
    border:1px solid #334155;
    border-radius:12px;
    padding:25px;
}
input{
    background:#0f172a!important;
    color:white!important;
    border:1px solid #475569!important;
}
.btn-login{
    background:#3b82f6;
    border:none;
}
.logo{
    width:80px;
    display:block;
    margin:auto;
}
</style>
</head>
<body>

<div class="login-box">
    <img src="../assets/img/logo.png" class="logo mb-3">

    <h4 class="text-center mb-3">تسجيل دخول الحسابات</h4>

    <?php if($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <label class="mb-1">اسم المستخدم</label>
        <input type="text" name="username" class="form-control mb-3" required>

        <label class="mb-1">كلمة المرور</label>
        <input type="password" name="password" class="form-control mb-4" required>

        <button class="btn btn-login w-100">
            <i class="bi bi-box-arrow-in-right"></i> دخول
        </button>
    </form>
</div>

</body>
</html>